/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class NameConstraintsExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_nameConstraints;
    private ArrayList<GeneralName> permitted;
    private ArrayList<GeneralName> excluded;

    public NameConstraintsExtension() {
        super(TYPE);
    }

    public NameConstraintsExtension(Vector<GeneralName> permitted, Vector<GeneralName> excluded) {
        this((List<GeneralName>)permitted, (List<GeneralName>)excluded);
    }

    public NameConstraintsExtension(List<GeneralName> permitted, List<GeneralName> excluded) {
        this(permitted, excluded, true);
    }

    public NameConstraintsExtension(Vector<GeneralName> permitted, Vector<GeneralName> excluded, boolean critical) {
        this((List<GeneralName>)permitted, (List<GeneralName>)excluded, critical);
    }

    public NameConstraintsExtension(List<GeneralName> permitted, List<GeneralName> excluded, boolean critical) {
        super(TYPE, critical);
        ArrayList<Object> arrayList = permitted == null ? null : (this.permitted = permitted instanceof ArrayList ? (ArrayList<Object>)permitted : new ArrayList<GeneralName>(permitted));
        this.excluded = excluded == null ? null : (excluded instanceof ArrayList ? (ArrayList<Object>)excluded : new ArrayList<GeneralName>(excluded));
        this.setValue(this.toByteArray());
    }

    public NameConstraintsExtension(InputStream is) throws IOException {
        super(is);
    }

    public Vector<GeneralName> getPermittedSubtrees() {
        ArrayList<GeneralName> l = this.getPermittedSubtreesAsList();
        return l == null ? null : new VectorOverArrayList(l);
    }

    public ArrayList<GeneralName> getPermittedSubtreesAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.permitted;
    }

    public Vector<GeneralName> getExcludedSubtrees() {
        ArrayList<GeneralName> l = this.getExcludedSubtreesAsList();
        return l == null ? null : new VectorOverArrayList(l);
    }

    public ArrayList<GeneralName> getExcludedSubtreesAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.excluded;
    }

    public void addPermittedSubtree(GeneralName name) {
        if (this.permitted == null) {
            this.permitted = new ArrayList();
        }
        this.permitted.add(name);
        this.setValue(this.toByteArray());
    }

    public void addExcludedSubtree(GeneralName name) {
        if (this.excluded == null) {
            this.excluded = new ArrayList();
        }
        this.excluded.add(name);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        ASN1Sequence s;
        int i;
        int len;
        ASN1Sequence nameCons = new ASN1Sequence();
        if (this.permitted != null && this.permitted.size() > 0) {
            ASN1GenericConstructed perm = new ASN1GenericConstructed(0);
            len = this.permitted.size();
            for (i = 0; i < len; ++i) {
                s = new ASN1Sequence();
                s.addElement((ASN1Object)this.permitted.get(i));
                perm.addElement((ASN1Object)s);
            }
            nameCons.addElement((ASN1Object)perm);
        }
        if (this.excluded != null && this.excluded.size() > 0) {
            ASN1GenericConstructed excl = new ASN1GenericConstructed(1);
            len = this.excluded.size();
            for (i = 0; i < len; ++i) {
                s = new ASN1Sequence();
                s.addElement((ASN1Object)this.excluded.get(i));
                excl.addElement((ASN1Object)s);
            }
            nameCons.addElement((ASN1Object)excl);
        }
        byte[] b = Utils.toBytes((Streamable)nameCons);
        this.isDecoded = true;
        return b;
    }

    private void decodeValue() {
        try {
            ASN1Sequence s;
            UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream sis = new ASN1SequenceInputStream((InputStream)is);
            if (sis.hasMoreData() && sis.getCurrentTag() == 0) {
                sis.setCurrentTag(16);
                ASN1SequenceInputStream permis = new ASN1SequenceInputStream((InputStream)sis);
                this.permitted = new ArrayList();
                while (permis.hasMoreData()) {
                    s = new ASN1Sequence((InputStream)permis);
                    this.permitted.add(new GeneralName(Utils.toStream((Streamable)s.elementAt(0))));
                }
                permis.terminate();
            }
            if (sis.hasMoreData() && sis.getCurrentTag() == 1) {
                sis.setCurrentTag(16);
                ASN1SequenceInputStream exclis = new ASN1SequenceInputStream((InputStream)sis);
                this.excluded = new ArrayList();
                while (exclis.hasMoreData()) {
                    s = new ASN1Sequence((InputStream)exclis);
                    this.excluded.add(new GeneralName(Utils.toStream((Streamable)s.elementAt(0))));
                }
                exclis.terminate();
            }
            sis.terminate();
            if (this.permitted == null && this.excluded == null) {
                throw new ASN1FormatException("No name constraints defined for extension");
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        int i;
        int size;
        boolean mid;
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer s = new StringBuffer("nameConstraintsExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean began = false;
        if (this.getPermittedSubtreesAsList() != null) {
            s.append("permitted = {");
            mid = false;
            size = this.getPermittedSubtreesAsList().size();
            for (i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(this.getPermittedSubtreesAsList().get(i).toString());
                mid = true;
            }
            s.append("}");
            began = true;
        }
        if (this.getExcludedSubtreesAsList() != null) {
            if (began) {
                s.append(", ");
            }
            s.append("excluded = {");
            mid = false;
            size = this.getExcludedSubtreesAsList().size();
            for (i = 0; i < size; ++i) {
                if (mid) {
                    s.append(", ");
                }
                s.append(this.getExcludedSubtreesAsList().get(i).toString());
                mid = true;
            }
            s.append("}");
        }
        s.append("]}");
        return s.toString();
    }
}

