/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command.teams;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.LicenseGuard;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.CleanResult;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.configuration.cleanmode.teams.CleanModeSupportedDatabases;
import org.flywaydb.core.internal.configuration.cleanmode.tier2.CleanModeConfigurationExtension;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.PlainExecutionTemplate;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.plugin.PluginRegister;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;

public class DbClean
extends org.flywaydb.core.internal.command.DbClean {
    private final CleanModeConfigurationExtension cleanModeConfigurationExtension;

    public DbClean(Database database, SchemaHistory schemaHistory, Schema defaultSchema, Schema[] schemas, CallbackExecutor callbackExecutor, Configuration configuration) {
        super(database, schemaHistory, defaultSchema, schemas, callbackExecutor, configuration);
        LicenseGuard.guard((Configuration)configuration, Arrays.asList(Edition.ENTERPRISE, Edition.PRO, Edition.TIER3), (String)"Flyway Clean Extension");
        this.cleanModeConfigurationExtension = (CleanModeConfigurationExtension)PluginRegister.getPlugin(CleanModeConfigurationExtension.class);
    }

    public void clean(CleanResult cleanResult) throws FlywayException {
        if (this.cleanModeConfigurationExtension.getCleanMode() == CleanModeConfigurationExtension.Mode.DEFAULT) {
            super.clean(cleanResult);
        } else {
            if (!CleanModeSupportedDatabases.supportsCleanMode(this.database)) {
                throw new FlywayException("Clean modes other than default are not supported for " + this.database.getDatabaseType().getName());
            }
            if (this.configuration.getSchemas().length > 0) {
                throw new FlywayException("'flyway.schemas' must be empty when using clean modes other than default");
            }
            Schema[] allSchemas = (Schema[])Arrays.stream(this.database.getAllSchemas()).filter(s -> !this.cleanModeConfigurationExtension.getCleanSchemasExclude().contains(s.getName())).toArray(Schema[]::new);
            if (this.cleanModeConfigurationExtension.getCleanMode() == CleanModeConfigurationExtension.Mode.SCHEMA) {
                this.clean(this.defaultSchema, allSchemas, cleanResult);
            } else if (this.cleanModeConfigurationExtension.getCleanMode() == CleanModeConfigurationExtension.Mode.ALL) {
                this.clean(this.defaultSchema, allSchemas, cleanResult, Arrays.stream(allSchemas).map(Schema::getName).collect(Collectors.toList()));
            }
        }
    }

    private void clean(Schema defaultSchema, Schema[] schemas, CleanResult cleanResult, List<String> dropSchemas) {
        try {
            this.connection.changeCurrentSchemaTo(defaultSchema);
            this.clean(schemas, cleanResult, dropSchemas);
        }
        catch (FlywayException e) {
            this.callbackExecutor.onEvent(Event.AFTER_CLEAN_ERROR);
            throw e;
        }
    }

    protected void doCleanSchema(Schema schema) {
        if (this.cleanModeConfigurationExtension.getCleanMode() == CleanModeConfigurationExtension.Mode.ALL) {
            new PlainExecutionTemplate(true).execute(() -> {
                schema.clean();
                return null;
            });
        } else {
            super.doCleanSchema(schema);
        }
    }
}

