/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.error.StandardException;

public class StatementRolePermission
extends StatementPermission {
    private String roleName;
    private int privType;

    public StatementRolePermission(String string, int n) {
        this.roleName = string;
        this.privType = n;
    }

    @Override
    public void check(LanguageConnectionContext languageConnectionContext, boolean bl, Activation activation) throws StandardException {
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        switch (this.privType) {
            case 19: {
                throw StandardException.newException((String)"4251A", (Object[])new Object[]{"CREATE ROLE"});
            }
            case 20: {
                throw StandardException.newException((String)"4251A", (Object[])new Object[]{"DROP ROLE"});
            }
        }
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        return null;
    }

    private String getPrivName() {
        switch (this.privType) {
            case 19: {
                return "CREATE_ROLE";
            }
            case 20: {
                return "DROP_ROLE";
            }
        }
        return "?";
    }

    public String toString() {
        return "StatementRolePermission: " + this.roleName + " " + this.getPrivName();
    }
}

