/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.schemahistory;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Connection;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.schemahistory.JdbcTableSchemaHistory;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.schemahistory.teams.InMemorySchemaHistory;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.core.internal.util.StringUtils;

public class SchemaHistoryFactory {
    private static final Log LOG = LogFactory.getLog(SchemaHistoryFactory.class);

    public static SchemaHistory getSchemaHistory(Configuration configuration, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Database database, Schema schema, StatementInterceptor statementInterceptor) {
        Table table = schema.getTable(configuration.getTable());
        JdbcTableSchemaHistory jdbcTableSchemaHistory = new JdbcTableSchemaHistory(sqlScriptExecutorFactory, sqlScriptFactory, database, table);
        if (configuration.getDryRunOutput() != null) {
            return new InMemorySchemaHistory(jdbcTableSchemaHistory.exists(), jdbcTableSchemaHistory.allAppliedMigrations(), table, database.getInstalledBy(), statementInterceptor, configuration);
        }
        return jdbcTableSchemaHistory;
    }

    public static Pair<Schema, List<Schema>> prepareSchemas(Configuration configuration, Database database) {
        Schema defaultSchema;
        Object[] schemaNames = configuration.getSchemas();
        Object defaultSchemaName = configuration.getDefaultSchema();
        LOG.debug("Schemas: " + StringUtils.arrayToCommaDelimitedString(schemaNames));
        LOG.debug("Default schema: " + (String)defaultSchemaName);
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (Object schemaName : schemaNames) {
            schemas.add(((Connection)database.getMainConnection()).getSchema((String)schemaName));
        }
        if (defaultSchemaName == null) {
            if (schemaNames.length == 0) {
                Schema currentSchema = ((Connection)database.getMainConnection()).getCurrentSchema();
                if (currentSchema == null || currentSchema.getName() == null) {
                    throw new FlywayException("Unable to determine schema for the schema history table. Set a default schema for the connection or specify one using the 'defaultSchema' property");
                }
                defaultSchemaName = currentSchema.getName();
            } else {
                defaultSchemaName = schemaNames[0];
            }
        }
        if (!schemas.contains(defaultSchema = ((Connection)database.getMainConnection()).getSchema((String)defaultSchemaName))) {
            schemas.add(0, defaultSchema);
        }
        return Pair.of(defaultSchema, schemas);
    }

    private SchemaHistoryFactory() {
    }
}

