/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.teams.db2zos;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.teams.db2zos.DB2zOSConnection;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;

public class DB2zOSDatabase
extends Database<DB2zOSConnection> {
    public DB2zOSDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    @Override
    protected DB2zOSConnection doGetConnection(Connection connection) {
        return new DB2zOSConnection(this.configuration, this, connection);
    }

    @Override
    public final void ensureSupported() {
        this.ensureDatabaseIsRecentEnough("12.1");
        this.recommendFlywayUpgradeIfNecessary("12.1");
    }

    @Override
    public String getRawCreateScript(Table table, boolean baseline) {
        if (this.configuration.getTablespace() == null) {
            throw new FlywayException("tablespace must be configured for Flyway to be able to create its schema history table");
        }
        return "CREATE TABLE \"" + table.getName() + "\" (\n    \"installed_rank\" INT NOT NULL CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP DEFAULT NOT NULL,\n    \"execution_time\" INT NOT NULL,\n    \"success\" SMALLINT NOT NULL\n) IN " + this.configuration.getTablespace() + ";\nCREATE UNIQUE INDEX \"" + table.getName() + "_pku\" ON \"" + table.getName() + "\" (\"installed_rank\");CREATE INDEX \"" + table.getName() + "_s_idx\" ON \"" + table.getName() + "\" (\"success\");" + (baseline ? this.getBaselineStatement(table) + ";\n" : "");
    }

    @Override
    public String getSelectStatement(Table table) {
        return super.getSelectStatement(table) + " WITH UR";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((DB2zOSConnection)this.getMainConnection()).getJdbcTemplate().queryForString("select CURRENT CLIENT_USERID from sysibm.sysdummy1", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public boolean supportsChangingCurrentSchema() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return false;
    }
}

