/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.teams;

import java.util.ArrayList;
import java.util.List;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.database.oracle.teams.AbstractSQLPlusParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusParserSqlScript;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusPlaceholderProvider;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLPlusAtParsedSqlStatement
extends AbstractSQLPlusParsedSqlStatement {
    private final SqlScript referencedSqlScript;

    public SQLPlusAtParsedSqlStatement(int pos, int line, int col, String sql, SQLPlusPlaceholderProvider sqlPlusPlaceholderProvider, Parser parser, ResourceProvider resourceProvider) {
        super(pos, line, col, SQLPlusAtParsedSqlStatement.extractAtStatement(sql));
        LoadableResource resource;
        sql = this.getSql();
        String noCommand = sql.startsWith("@") ? StringUtils.trimLeadingCharacter(sql, '@').trim() : sql.substring(sql.indexOf(32)).trim();
        List<String> tokens = StringUtils.tokenizeToStringCollection(noCommand, " ");
        String file = tokens.get(0);
        if (!file.contains(".") || file.endsWith(".")) {
            file = file + "." + sqlPlusPlaceholderProvider.getSuffix();
        }
        if ((resource = resourceProvider.getResource(file)) == null) {
            throw new FlywayException("SP2-0310: unable to open file \"" + file + "\"");
        }
        ArrayList<String> params = new ArrayList<String>();
        for (int i = 1; i < tokens.size(); ++i) {
            params.add(tokens.get(i));
        }
        LoadableResource metadataResource = SqlScriptMetadata.getMetadataResource(resourceProvider, resource);
        this.referencedSqlScript = new SQLPlusParserSqlScript(parser, resource, metadataResource, false, params);
    }

    private static String extractAtStatement(String sql) {
        String[] split;
        for (String line : split = sql.split("\n")) {
            String trimmed = line.trim();
            if (!trimmed.startsWith("@")) continue;
            return trimmed;
        }
        return sql;
    }

    @Override
    public SqlScript getReferencedSqlScript() {
        return this.referencedSqlScript;
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        sqlScriptExecutor.execute(this.referencedSqlScript);
        return new Results();
    }
}

