/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.flywaydb.commandline.ConsoleLogCreator;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.internal.info.MigrationInfoDumper;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.ExceptionUtils;
import org.flywaydb.core.internal.util.FileCopyUtils;
import org.flywaydb.core.internal.util.PropertiesUtils;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogCreator;
import org.flywaydb.core.internal.util.logging.LogFactory;
import org.flywaydb.core.internal.util.scanner.classpath.ClassPathResource;

public class Main {
    private static Log LOG;

    static void initLogging(boolean debug) {
        LogFactory.setLogCreator((LogCreator)new ConsoleLogCreator(debug));
        LOG = LogFactory.getLog(Main.class);
    }

    public static void main(String[] args) {
        boolean debug = Main.isDebug(args);
        Main.initLogging(debug);
        try {
            Main.printVersion();
            List<String> operations = Main.determineOperations(args);
            if (operations.isEmpty()) {
                Main.printUsage();
                return;
            }
            Properties properties = new Properties();
            Main.initializeDefaults(properties);
            Main.loadConfigurationFile(properties, args);
            Main.overrideConfiguration(properties, args);
            Main.loadJdbcDriversAndJavaMigrations(properties);
            Flyway flyway = new Flyway();
            flyway.configure(properties);
            int consoleWidth = PropertiesUtils.getIntProperty((Properties)properties, (String)"flyway.consoleWidth", (int)80);
            for (String operation : operations) {
                Main.executeOperation(flyway, operation, consoleWidth);
            }
        }
        catch (Exception e) {
            if (debug) {
                LOG.error("Unexpected error", e);
            } else {
                if (e instanceof FlywayException) {
                    LOG.error(e.getMessage());
                } else {
                    LOG.error(e.toString());
                }
                Throwable cause = ExceptionUtils.getRootCause((Throwable)e);
                LOG.error("Caused by: " + cause.toString());
                Main.outputFirstStackTraceElement(cause);
            }
            System.exit(1);
        }
    }

    private static void executeOperation(Flyway flyway, String operation, int consoleWidth) {
        if ("clean".equals(operation)) {
            flyway.clean();
        } else if ("init".equals(operation)) {
            flyway.init();
        } else if ("migrate".equals(operation)) {
            flyway.migrate();
        } else if ("validate".equals(operation)) {
            flyway.validate();
        } else if ("info".equals(operation)) {
            LOG.info("\n" + MigrationInfoDumper.dumpToAsciiTable((MigrationInfo[])flyway.info().all(), (int)consoleWidth));
        } else if ("repair".equals(operation)) {
            flyway.repair();
        } else {
            LOG.error("Invalid operation: " + operation);
            Main.printUsage();
            System.exit(1);
        }
    }

    private static boolean isDebug(String[] args) {
        for (String arg : args) {
            if (!"-X".equals(arg)) continue;
            return true;
        }
        return false;
    }

    private static void outputFirstStackTraceElement(Throwable t) {
        StackTraceElement firstStackTraceElement = t.getStackTrace()[0];
        LOG.error("Occured in " + firstStackTraceElement.getClassName() + "." + firstStackTraceElement.getMethodName() + "() at line " + firstStackTraceElement.getLineNumber());
    }

    private static void initializeDefaults(Properties properties) {
        properties.put("flyway.locations", "filesystem:" + Main.getInstallationDir() + "/sql");
        properties.put("flyway.jarDir", Main.getInstallationDir() + "/jars");
    }

    private static void printVersion() throws IOException {
        String version = new ClassPathResource("version.txt", Thread.currentThread().getContextClassLoader()).loadAsString("UTF-8");
        LOG.info("Flyway (Command-line Tool) v." + version);
        LOG.info("");
    }

    private static void printUsage() {
        LOG.info("********");
        LOG.info("* Usage");
        LOG.info("********");
        LOG.info("");
        LOG.info("flyway [options] command");
        LOG.info("");
        LOG.info("By default, the configuration will be read from conf/flyway.properties.");
        LOG.info("Options passed from the command-line override the configuration.");
        LOG.info("");
        LOG.info("Commands");
        LOG.info("========");
        LOG.info("migrate  : Migrates the database");
        LOG.info("clean    : Drops all objects in the configured schemas");
        LOG.info("info     : Prints the information about applied, current and pending migrations");
        LOG.info("validate : Validates the applied migrations against the ones on the classpath");
        LOG.info("init     : Creates and initializes the metadata table");
        LOG.info("repair   : Repairs the metadata table");
        LOG.info("");
        LOG.info("Options (Format: -key=value)");
        LOG.info("=======");
        LOG.info("driver                 : Fully qualified classname of the jdbc driver");
        LOG.info("url                    : Jdbc url to use to connect to the database");
        LOG.info("user                   : User to use to connect to the database");
        LOG.info("password               : Password to use to connect to the database");
        LOG.info("schemas                : Comma-separated list of the schemas managed by Flyway");
        LOG.info("table                  : Name of Flyway's metadata table");
        LOG.info("locations              : Classpath locations to scan recursively for migrations");
        LOG.info("resolvers              : Comma-separated list of custom MigrationResolvers");
        LOG.info("sqlMigrationPrefix     : File name prefix for Sql migrations");
        LOG.info("sqlMigrationSeparator  : File name separator for Sql migrations");
        LOG.info("sqlMigrationSuffix     : File name suffix for Sql migrations");
        LOG.info("encoding               : Encoding of Sql migrations");
        LOG.info("placeholders           : Placeholders to replace in Sql migrations");
        LOG.info("placeholderPrefix      : Prefix of every placeholder");
        LOG.info("placeholderSuffix      : Suffix of every placeholder");
        LOG.info("target                 : Target version up to which Flyway should migrate");
        LOG.info("outOfOrder             : Allows migrations to be run \"out of order\"");
        LOG.info("callbacks              : Comma-separated list of FlywayCallback classes");
        LOG.info("validateOnMigrate      : Validate when running migrate");
        LOG.info("cleanOnValidationError : Automatically clean on a validation error");
        LOG.info("initVersion            : Version to tag schema with when executing init");
        LOG.info("initDescription        : Description to tag schema with when executing init");
        LOG.info("initOnMigrate          : Init on migrate against uninitialized non-empty schema");
        LOG.info("configFile             : Config file to use (default: conf/flyway.properties)");
        LOG.info("configFileEncoding     : Encoding of the config file (default: UTF-8)");
        LOG.info("jarDir                 : Dir for Jdbc drivers & Java migrations (default: jars)");
        LOG.info("");
        LOG.info("Add -X to print debug output");
        LOG.info("");
        LOG.info("Example");
        LOG.info("=======");
        LOG.info("flyway -target=1.5 -placeholders.user=my_user info");
        LOG.info("");
        LOG.info("More info at http://flywaydb.org/documentation/commandline");
    }

    private static void loadJdbcDriversAndJavaMigrations(Properties properties) throws IOException {
        String directoryForJdbcDriversAndJavaMigrations = properties.getProperty("flyway.jarDir");
        File dir = new File(directoryForJdbcDriversAndJavaMigrations);
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files == null) {
            LOG.error("Directory for JDBC drivers and JavaMigrations not found: " + directoryForJdbcDriversAndJavaMigrations);
            System.exit(1);
        }
        for (File file : files) {
            Main.addJarOrDirectoryToClasspath(file.getPath());
        }
    }

    static void addJarOrDirectoryToClasspath(String name) throws IOException {
        LOG.debug("Adding location to classpath: " + name);
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new File(name).toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(urlClassLoader);
    }

    static void loadConfigurationFile(Properties properties, String[] args) throws FlywayException {
        String configFile = Main.determineConfigurationFile(args);
        if (configFile != null) {
            try {
                String encoding = Main.determineConfigurationFileEncoding(args);
                InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(configFile), encoding);
                String propertiesData = FileCopyUtils.copyToString((Reader)fileReader);
                properties.putAll((Map<?, ?>)PropertiesUtils.loadPropertiesFromString((String)propertiesData));
            }
            catch (IOException e) {
                throw new FlywayException("Unable to load config file: " + configFile, (Throwable)e);
            }
        }
    }

    private static String determineConfigurationFile(String[] args) {
        for (String arg : args) {
            if (!Main.isPropertyArgument(arg) || !"configFile".equals(Main.getArgumentProperty(arg))) continue;
            return Main.getArgumentValue(arg);
        }
        return Main.getInstallationDir() + "/conf/flyway.properties";
    }

    private static String getInstallationDir() {
        String path = ClassUtils.getLocationOnDisk(Main.class);
        return path.substring(0, path.lastIndexOf("/")) + "/..";
    }

    private static String determineConfigurationFileEncoding(String[] args) {
        for (String arg : args) {
            if (!Main.isPropertyArgument(arg) || !"configFileEncoding".equals(Main.getArgumentProperty(arg))) continue;
            return Main.getArgumentValue(arg);
        }
        return "UTF-8";
    }

    static void overrideConfiguration(Properties properties, String[] args) {
        for (String arg : args) {
            if (!Main.isPropertyArgument(arg)) continue;
            properties.put("flyway." + Main.getArgumentProperty(arg), Main.getArgumentValue(arg));
        }
    }

    static boolean isPropertyArgument(String arg) {
        return arg.startsWith("-") && arg.contains("=");
    }

    static String getArgumentProperty(String arg) {
        int index = arg.indexOf("=");
        return arg.substring(1, index);
    }

    static String getArgumentValue(String arg) {
        int index = arg.indexOf("=");
        if (index < 0 || index == arg.length()) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static List<String> determineOperations(String[] args) {
        ArrayList<String> operations = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            operations.add(arg);
        }
        return operations;
    }
}

