/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.flywaydb.commandline.Main;
import org.flywaydb.commandline.configuration.CommandLineArguments;
import org.flywaydb.commandline.configuration.CommandLineConfigurationUtils;
import org.flywaydb.commandline.configuration.ConfigurationManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.ClassicConfiguration;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.ConfigurationExtension;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.configuration.TomlUtils;
import org.flywaydb.core.internal.configuration.models.ConfigurationModel;
import org.flywaydb.core.internal.configuration.models.EnvironmentModel;
import org.flywaydb.core.internal.configuration.models.ResolvedEnvironment;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.MergeUtils;

public class ModernConfigurationManager
implements ConfigurationManager {
    private static final Log LOG = LogFactory.getLog(ModernConfigurationManager.class);
    private static final Pattern ANY_WORD_BETWEEN_TWO_QUOTES_PATTERN = Pattern.compile("\"([^\"]*)\"");

    @Override
    public Configuration getConfiguration(CommandLineArguments commandLineArguments) {
        File sqlFolder;
        String workingDirectory = commandLineArguments.isWorkingDirectorySet() ? commandLineArguments.getWorkingDirectory() : ClassUtils.getInstallDir(Main.class);
        List tomlFiles = ConfigUtils.getDefaultTomlConfigFileLocations((File)new File(ClassUtils.getInstallDir(Main.class)));
        tomlFiles.addAll(CommandLineConfigurationUtils.getTomlConfigFilePaths());
        tomlFiles.addAll(commandLineArguments.getConfigFiles().stream().map(File::new).collect(Collectors.toList()));
        List existingFiles = tomlFiles.stream().filter(File::exists).collect(Collectors.toList());
        ConfigurationModel config = TomlUtils.loadConfigurationFiles(existingFiles, (String)workingDirectory);
        ConfigurationModel commandLineArgumentsModel = TomlUtils.loadConfigurationFromCommandlineArgs(commandLineArguments.getConfiguration(true));
        ConfigurationModel environmentVariablesModel = TomlUtils.loadConfigurationFromEnvironment();
        config = config.merge(environmentVariablesModel).merge(commandLineArgumentsModel);
        if (commandLineArgumentsModel.getEnvironments().containsKey("tempConfigEnvironment") || environmentVariablesModel.getEnvironments().containsKey("tempConfigEnvironment")) {
            EnvironmentModel defaultEnv = (EnvironmentModel)config.getEnvironments().get(config.getFlyway().getEnvironment());
            if (environmentVariablesModel.getEnvironments().containsKey("tempConfigEnvironment")) {
                config.getEnvironments().put(config.getFlyway().getEnvironment(), defaultEnv.merge((EnvironmentModel)environmentVariablesModel.getEnvironments().get("tempConfigEnvironment")));
            }
            if (commandLineArgumentsModel.getEnvironments().containsKey("tempConfigEnvironment")) {
                config.getEnvironments().put(config.getFlyway().getEnvironment(), defaultEnv.merge((EnvironmentModel)commandLineArgumentsModel.getEnvironments().get("tempConfigEnvironment")));
            }
            config.getEnvironments().remove("tempConfigEnvironment");
        }
        if (ConfigUtils.shouldUseDefaultCliSqlLocation((File)(sqlFolder = new File(workingDirectory, "sql")), (!config.getFlyway().getLocations().equals(ConfigurationModel.defaults().getFlyway().getLocations()) ? 1 : 0) != 0)) {
            config.getFlyway().setLocations(Arrays.asList("filesystem:" + sqlFolder.getAbsolutePath()));
        }
        ConfigUtils.dumpConfigurationModel((ConfigurationModel)config);
        ClassicConfiguration cfg = new ClassicConfiguration(config);
        this.configurePlugins(config, cfg);
        ModernConfigurationManager.loadJarDirsAndAddToClasspath(workingDirectory, cfg);
        return cfg;
    }

    private void configurePlugins(ConfigurationModel config, ClassicConfiguration cfg) {
        ArrayList<String> configuredPluginParameters = new ArrayList<String>();
        for (ConfigurationExtension configurationExtension : cfg.getPluginRegister().getPlugins(ConfigurationExtension.class)) {
            if (configurationExtension.getNamespace().isEmpty()) {
                this.processParametersByNamespace("plugins", config, configurationExtension, configuredPluginParameters);
            }
            this.processParametersByNamespace(configurationExtension.getNamespace(), config, configurationExtension, configuredPluginParameters);
        }
        Map pluginConfigurations = config.getFlyway().getPluginConfigurations();
        pluginConfigurations.remove("jarDirs");
        ArrayList<Object> pluginParametersWhichShouldHaveBeenConfigured = new ArrayList<Object>();
        for (Map.Entry configuration : pluginConfigurations.entrySet()) {
            if (configuration.getValue() instanceof Map) {
                Map temp = (Map)configuration.getValue();
                pluginParametersWhichShouldHaveBeenConfigured.addAll(temp.keySet());
                continue;
            }
            pluginParametersWhichShouldHaveBeenConfigured.add((String)configuration.getKey());
        }
        List<String> missingParams = pluginParametersWhichShouldHaveBeenConfigured.stream().filter(p -> !configuredPluginParameters.contains(p)).toList();
        if (!missingParams.isEmpty()) {
            throw new FlywayException("Failed to configure Parameters: " + missingParams.stream().collect(Collectors.joining(", ")));
        }
    }

    private static void loadJarDirsAndAddToClasspath(String workingDirectory, ClassicConfiguration cfg) {
        ResolvedEnvironment resolvedEnvironment;
        ArrayList<String> jarDirs = new ArrayList<String>();
        File jarDir = new File(workingDirectory, "jars");
        ConfigUtils.warnIfUsingDeprecatedMigrationsFolder((File)jarDir, (String)".jar");
        if (jarDir.exists()) {
            jarDirs.add(jarDir.getAbsolutePath());
        }
        if ((resolvedEnvironment = cfg.getCurrentResolvedEnvironment()) != null) {
            jarDirs.addAll(resolvedEnvironment.getJarDirs());
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<File> jarFiles = new ArrayList<File>();
        jarFiles.addAll(CommandLineConfigurationUtils.getJdbcDriverJarFiles());
        jarFiles.addAll(CommandLineConfigurationUtils.getJavaMigrationJarFiles(jarDirs.toArray(new String[0])));
        if (!jarFiles.isEmpty()) {
            classLoader = ClassUtils.addJarsOrDirectoriesToClasspath((ClassLoader)classLoader, jarFiles);
        }
        cfg.setClassLoader(classLoader);
    }

    private void processParametersByNamespace(String namespace, ConfigurationModel config, ConfigurationExtension configurationExtension, List<String> configuredPluginParameters) {
        block9: {
            Map<String, Object> pluginConfigs = config.getFlyway().getPluginConfigurations();
            boolean suppressError = false;
            if (namespace.startsWith("\\")) {
                suppressError = true;
                namespace = namespace.substring(1);
                pluginConfigs = config.getRootConfigurations();
            }
            if (pluginConfigs.containsKey(namespace) || namespace.isEmpty()) {
                List fields = Arrays.stream(configurationExtension.getClass().getDeclaredFields()).map(Field::getName).collect(Collectors.toList());
                Map<String, Object> values = !namespace.isEmpty() ? (Map)pluginConfigs.get(namespace) : pluginConfigs;
                values = values.entrySet().stream().filter(p -> fields.stream().anyMatch(k -> k.equalsIgnoreCase((String)p.getKey()))).collect(Collectors.toMap(p -> fields.stream().filter(q -> q.equalsIgnoreCase((String)p.getKey())).findFirst().orElse((String)p.getKey()), Map.Entry::getValue));
                try {
                    if (configurationExtension.isStub() && new HashSet<String>(configuredPluginParameters).containsAll(values.keySet())) {
                        return;
                    }
                    ConfigurationExtension newConfigurationExtension = (ConfigurationExtension)new ObjectMapper().convertValue(values, configurationExtension.getClass());
                    MergeUtils.mergeModel((Object)newConfigurationExtension, (Object)configurationExtension);
                    if (!values.isEmpty()) {
                        for (Map.Entry<String, Object> entry : values.entrySet()) {
                            if (entry.getValue() instanceof Map && namespace.isEmpty()) {
                                Map temp = (Map)entry.getValue();
                                configuredPluginParameters.addAll(temp.keySet());
                                continue;
                            }
                            configuredPluginParameters.add(entry.getKey());
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    Matcher matcher = ANY_WORD_BETWEEN_TWO_QUOTES_PATTERN.matcher(e.getMessage());
                    if (!matcher.find()) break block9;
                    if (suppressError) {
                        LOG.warn("Unable to parse the field: " + matcher.group(1));
                    }
                    LOG.error("Unable to parse the field: " + matcher.group(1));
                }
            }
        }
    }
}

