/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.commandline.configuration;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.flywaydb.commandline.Main;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class CommandLineConfigurationUtils {
    private static final Log LOG = LogFactory.getLog(CommandLineConfigurationUtils.class);

    public static List<File> getTomlConfigFilePaths() {
        String[] fileLocations = StringUtils.tokenizeToStringArray((String)System.getenv("FLYWAY_CONFIG_FILES"), (String)",");
        return fileLocations == null ? new ArrayList<File>() : Arrays.stream(fileLocations).filter(f -> f.endsWith(".toml")).map(File::new).collect(Collectors.toList());
    }

    public static List<File> getJdbcDriverJarFiles() {
        File driversDir = new File(ClassUtils.getInstallDir(Main.class), "drivers");
        File[] files = driversDir.listFiles((dir, name) -> name.endsWith(".jar"));
        if (files == null) {
            LOG.debug("Directory for Jdbc Drivers not found: " + driversDir.getAbsolutePath());
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    public static List<File> getJavaMigrationJarFiles(String[] dirs) {
        if (dirs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> jarFiles = new ArrayList<File>();
        for (String dirName : dirs) {
            File dir = new File(dirName);
            File[] files = dir.listFiles((dir1, name) -> name.endsWith(".jar"));
            if (files == null) {
                throw new FlywayException("Directory for Java Migrations not found: " + dirName);
            }
            jarFiles.addAll(Arrays.asList(files));
        }
        return jarFiles;
    }

    private CommandLineConfigurationUtils() {
    }
}

