/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime.variable;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.ui.task.model.runtime.RestVariable;
import org.flowable.ui.task.rest.runtime.variable.RestVariableConverter;
import org.springframework.stereotype.Component;

@Component
public class DoubleRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "double";
    }

    @Override
    public Class<?> getVariableType() {
        return Double.class;
    }

    @Override
    public Object getVariableValue(RestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof Number)) {
                throw new FlowableIllegalArgumentException("Converter can only convert doubles");
            }
            return ((Number)result.getValue()).doubleValue();
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, RestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof Double)) {
                throw new FlowableIllegalArgumentException("Converter can only convert doubles");
            }
            result.setValue(variableValue);
        } else {
            result.setValue(null);
        }
    }
}

