/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.rest.runtime;

import java.util.Collection;
import java.util.List;
import org.flowable.engine.event.EventLogEntry;
import org.flowable.ui.task.model.debugger.BreakpointRepresentation;
import org.flowable.ui.task.model.debugger.ExecutionRepresentation;
import org.flowable.ui.task.service.debugger.DebuggerRestVariable;
import org.flowable.ui.task.service.debugger.DebuggerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class DebuggerResource {
    @Autowired
    protected DebuggerService debuggerService;
    @Autowired
    protected Environment environment;

    @GetMapping(value={"/rest/debugger/breakpoints"}, produces={"application/json"})
    public Collection<BreakpointRepresentation> getBreakpoints() {
        this.assertDebuggerEnabled();
        return this.debuggerService.getBreakpoints();
    }

    @PostMapping(value={"/rest/debugger/breakpoints"})
    public void addBreakPoints(@RequestBody BreakpointRepresentation breakpointRepresentation) {
        this.assertDebuggerEnabled();
        this.debuggerService.addBreakpoint(breakpointRepresentation);
    }

    @PutMapping(value={"/rest/debugger/breakpoints/{executionId}/continue"})
    public void continueExecution(@PathVariable String executionId) {
        this.assertDebuggerEnabled();
        this.debuggerService.continueExecution(executionId);
    }

    @DeleteMapping(value={"/rest/debugger/breakpoints"})
    public void deleteBreakPoints(@RequestBody BreakpointRepresentation breakpointRepresentation) {
        this.assertDebuggerEnabled();
        this.debuggerService.removeBreakpoint(breakpointRepresentation);
    }

    @GetMapping(value={"/rest/debugger/eventlog/{processInstanceId}"})
    public List<EventLogEntry> getEventLog(@PathVariable String processInstanceId) {
        this.assertDebuggerEnabled();
        return this.debuggerService.getProcessInstanceEventLog(processInstanceId);
    }

    @GetMapping(value={"/rest/debugger/variables/{executionId}"})
    public List<DebuggerRestVariable> getExecutionVariables(@PathVariable String executionId) {
        this.assertDebuggerEnabled();
        return this.debuggerService.getExecutionVariables(executionId);
    }

    @GetMapping(value={"/rest/debugger/executions/{processInstanceId}"})
    public List<ExecutionRepresentation> getExecutions(@PathVariable String processInstanceId) {
        this.assertDebuggerEnabled();
        return this.debuggerService.getExecutions(processInstanceId);
    }

    @PostMapping(value={"/rest/debugger/evaluate/expression/{executionId}"}, produces={"application/text"})
    public String evaluateExpression(@PathVariable String executionId, @RequestBody String expression) {
        this.assertDebuggerEnabled();
        return this.debuggerService.evaluateExpression(executionId, expression).toString();
    }

    @PostMapping(value={"/rest/debugger/evaluate/{scriptLanguage}/{executionId}"})
    public void evaluateScript(@PathVariable String executionId, @PathVariable String scriptLanguage, @RequestBody String script) {
        this.assertDebuggerEnabled();
        this.debuggerService.evaluateScript(executionId, scriptLanguage, script);
    }

    @GetMapping(value={"/rest/debugger"})
    public boolean isDebuggerAllowed() {
        return (Boolean)this.environment.getProperty("flowable.experimental.debugger.enabled", Boolean.class, (Object)false);
    }

    protected void assertDebuggerEnabled() {
        if (!((Boolean)this.environment.getProperty("flowable.experimental.debugger.enabled", Boolean.class, (Object)false)).booleanValue()) {
            throw new RuntimeException("property flowable.experimental.debugger.enabled is not enabled");
        }
    }
}

