/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.model.runtime;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.idm.api.User;
import org.flowable.ui.common.model.AbstractRepresentation;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.task.model.runtime.RestVariable;

public class CaseInstanceRepresentation
extends AbstractRepresentation {
    protected String id;
    protected String name;
    protected String businessKey;
    protected String caseDefinitionId;
    protected String tenantId;
    protected Date started;
    protected Date ended;
    protected UserRepresentation startedBy;
    protected String caseDefinitionName;
    protected String caseDefinitionDescription;
    protected String caseDefinitionKey;
    protected String caseDefinitionCategory;
    protected int caseDefinitionVersion;
    protected String caseDefinitionDeploymentId;
    protected boolean graphicalNotationDefined;
    protected boolean startFormDefined;
    protected List<RestVariable> variables = new ArrayList<RestVariable>();

    public CaseInstanceRepresentation(CaseInstance caseInstance, CaseDefinition caseDefinition, boolean graphicalNotation, User startedBy) {
        this(caseInstance, graphicalNotation, startedBy);
        this.mapCaseDefinition(caseDefinition);
    }

    public CaseInstanceRepresentation(CaseInstance caseInstance, boolean graphicalNotation, User startedBy) {
        this.id = caseInstance.getId();
        this.name = caseInstance.getName();
        this.businessKey = caseInstance.getBusinessKey();
        this.caseDefinitionId = caseInstance.getCaseDefinitionId();
        this.tenantId = caseInstance.getTenantId();
        this.graphicalNotationDefined = graphicalNotation;
        if (startedBy != null) {
            this.startedBy = new UserRepresentation(startedBy);
        } else if (caseInstance.getStartUserId() != null) {
            this.startedBy = new UserRepresentation(caseInstance.getStartUserId());
        }
    }

    public CaseInstanceRepresentation(HistoricCaseInstance caseInstance, CaseDefinition caseDefinition, boolean graphicalNotation, User startedBy) {
        this(caseInstance, graphicalNotation, startedBy);
        this.mapCaseDefinition(caseDefinition);
    }

    public CaseInstanceRepresentation(HistoricCaseInstance caseInstance, boolean graphicalNotation, User startedBy) {
        this.id = caseInstance.getId();
        this.name = caseInstance.getName();
        this.businessKey = caseInstance.getBusinessKey();
        this.caseDefinitionId = caseInstance.getCaseDefinitionId();
        this.tenantId = caseInstance.getTenantId();
        this.started = caseInstance.getStartTime();
        this.ended = caseInstance.getEndTime();
        this.graphicalNotationDefined = graphicalNotation;
        if (startedBy != null) {
            this.startedBy = new UserRepresentation(startedBy);
        } else if (caseInstance.getStartUserId() != null) {
            this.startedBy = new UserRepresentation(caseInstance.getStartUserId());
        }
    }

    protected void mapCaseDefinition(CaseDefinition caseDefinition) {
        if (caseDefinition != null) {
            this.caseDefinitionName = caseDefinition.getName();
            this.caseDefinitionDescription = caseDefinition.getDescription();
            this.caseDefinitionKey = caseDefinition.getKey();
            this.caseDefinitionCategory = caseDefinition.getCategory();
            this.caseDefinitionVersion = caseDefinition.getVersion();
            this.caseDefinitionDeploymentId = caseDefinition.getDeploymentId();
            this.startFormDefined = caseDefinition.hasStartFormKey();
        }
    }

    public CaseInstanceRepresentation() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public UserRepresentation getStartedBy() {
        return this.startedBy;
    }

    public void setStartedBy(UserRepresentation startedBy) {
        this.startedBy = startedBy;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Date getStarted() {
        return this.started;
    }

    public void setStarted(Date started) {
        this.started = started;
    }

    public Date getEnded() {
        return this.ended;
    }

    public void setEnded(Date ended) {
        this.ended = ended;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    public void setCaseDefinitionName(String caseDefinitionName) {
        this.caseDefinitionName = caseDefinitionName;
    }

    public String getCaseDefinitionDescription() {
        return this.caseDefinitionDescription;
    }

    public void setCaseDefinitionDescription(String caseDefinitionDescription) {
        this.caseDefinitionDescription = caseDefinitionDescription;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    public String getCaseDefinitionCategory() {
        return this.caseDefinitionCategory;
    }

    public void setCaseDefinitionCategory(String caseDefinitionCategory) {
        this.caseDefinitionCategory = caseDefinitionCategory;
    }

    public int getCaseDefinitionVersion() {
        return this.caseDefinitionVersion;
    }

    public void setCaseDefinitionVersion(int caseDefinitionVersion) {
        this.caseDefinitionVersion = caseDefinitionVersion;
    }

    public String getCaseDefinitionDeploymentId() {
        return this.caseDefinitionDeploymentId;
    }

    public void setCaseDefinitionDeploymentId(String caseDefinitionDeploymentId) {
        this.caseDefinitionDeploymentId = caseDefinitionDeploymentId;
    }

    public List<RestVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<RestVariable> variables) {
        this.variables = variables;
    }

    public void addVariable(RestVariable variable) {
        this.variables.add(variable);
    }

    public boolean isGraphicalNotationDefined() {
        return this.graphicalNotationDefined;
    }

    public void setGraphicalNotationDefined(boolean graphicalNotationDefined) {
        this.graphicalNotationDefined = graphicalNotationDefined;
    }

    public boolean isStartFormDefined() {
        return this.startFormDefined;
    }

    public void setStartFormDefined(boolean startFormDefined) {
        this.startFormDefined = startFormDefined;
    }
}

