/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.service.keycloak;

import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.GroupQuery;
import org.flowable.idm.api.NativeGroupQuery;
import org.flowable.idm.api.NativeUserQuery;
import org.flowable.idm.api.PrivilegeMapping;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.IdmIdentityServiceImpl;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntityImpl;
import org.flowable.idm.engine.impl.persistence.entity.UserEntityImpl;
import org.flowable.ui.idm.service.keycloak.KeycloakConfiguration;
import org.flowable.ui.idm.service.keycloak.KeycloakGroupQueryImpl;
import org.flowable.ui.idm.service.keycloak.KeycloakUserQueryImpl;

public class KeycloakIdentityServiceImpl
extends IdmIdentityServiceImpl {
    protected KeycloakConfiguration keycloakConfiguration;

    public KeycloakIdentityServiceImpl(KeycloakConfiguration keycloakConfiguration, IdmEngineConfiguration idmEngineConfiguration) {
        super(idmEngineConfiguration);
        this.keycloakConfiguration = keycloakConfiguration;
    }

    public UserQuery createUserQuery() {
        return new KeycloakUserQueryImpl(this.keycloakConfiguration);
    }

    public GroupQuery createGroupQuery() {
        return new KeycloakGroupQueryImpl(this.keycloakConfiguration);
    }

    public boolean checkPassword(String userId, String password) {
        return super.checkPassword(userId, password);
    }

    public List<Group> getGroupsWithPrivilege(String name) {
        ArrayList<Group> groups = new ArrayList<Group>();
        List privilegeMappings = this.getPrivilegeMappingsByPrivilegeId(name);
        for (PrivilegeMapping privilegeMapping : privilegeMappings) {
            if (privilegeMapping.getGroupId() == null) continue;
            GroupEntityImpl group = new GroupEntityImpl();
            group.setId(privilegeMapping.getGroupId());
            group.setName(privilegeMapping.getGroupId());
            groups.add((Group)group);
        }
        return groups;
    }

    public List<User> getUsersWithPrivilege(String name) {
        ArrayList<User> users = new ArrayList<User>();
        List privilegeMappings = this.getPrivilegeMappingsByPrivilegeId(name);
        for (PrivilegeMapping privilegeMapping : privilegeMappings) {
            if (privilegeMapping.getUserId() == null) continue;
            UserEntityImpl user = new UserEntityImpl();
            user.setId(privilegeMapping.getUserId());
            user.setLastName(privilegeMapping.getUserId());
            users.add((User)user);
        }
        return users;
    }

    public User newUser(String userId) {
        throw new FlowableException("Keycloak identity service doesn't support creating a new user");
    }

    public void saveUser(User user) {
        throw new FlowableException("Keycloak identity service doesn't support saving an user");
    }

    public NativeUserQuery createNativeUserQuery() {
        throw new FlowableException("Keycloak identity service doesn't support native querying");
    }

    public void deleteUser(String userId) {
        throw new FlowableException("Keycloak identity service doesn't support deleting an user");
    }

    public Group newGroup(String groupId) {
        throw new FlowableException("Keycloak identity service doesn't support creating a new group");
    }

    public NativeGroupQuery createNativeGroupQuery() {
        throw new FlowableException("Keycloak identity service doesn't support native querying");
    }

    public void saveGroup(Group group) {
        throw new FlowableException("Keycloak identity service doesn't support saving a group");
    }

    public void deleteGroup(String groupId) {
        throw new FlowableException("Keycloak identity service doesn't support deleting a group");
    }
}

