/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.service.keycloak;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.idm.api.Group;
import org.flowable.idm.engine.impl.GroupQueryImpl;
import org.flowable.idm.engine.impl.persistence.entity.GroupEntityImpl;
import org.flowable.ui.idm.service.keycloak.KeycloakConfiguration;
import org.flowable.ui.idm.service.keycloak.KeycloakGroupRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.util.UriComponentsBuilder;

public class KeycloakGroupQueryImpl
extends GroupQueryImpl {
    protected static final Logger LOGGER = LoggerFactory.getLogger(KeycloakGroupQueryImpl.class);
    protected static final ParameterizedTypeReference<List<KeycloakGroupRepresentation>> KEYCLOAK_LIST_OF_GROUPS = new ParameterizedTypeReference<List<KeycloakGroupRepresentation>>(){};
    protected KeycloakConfiguration keycloakConfiguration;

    public KeycloakGroupQueryImpl(KeycloakConfiguration keycloakConfiguration) {
        this.keycloakConfiguration = keycloakConfiguration;
    }

    public long executeCount(CommandContext commandContext) {
        UriComponentsBuilder builder = this.prepareQuery("groups/count");
        URI uri = builder.buildAndExpand(new Object[]{this.keycloakConfiguration.getRealm()}).toUri();
        ResponseEntity response = this.keycloakConfiguration.getRestTemplate().getForEntity(uri, JsonNode.class);
        HttpStatus statusCode = response.getStatusCode();
        if (statusCode.is2xxSuccessful()) {
            LOGGER.debug("Successful response from keycloak");
            JsonNode groupsCountNode = (JsonNode)response.getBody();
            if (groupsCountNode != null) {
                if (groupsCountNode.isNumber()) {
                    return groupsCountNode.numberValue().longValue();
                }
                return groupsCountNode.path("count").asLong(0L);
            }
            LOGGER.warn("Keycloak didn't return any body when querying users");
            return 0L;
        }
        throw new FlowableException("Keycloak returned status code: " + statusCode);
    }

    public List<Group> executeList(CommandContext commandContext) {
        List<Group> groups = this.queryGroups();
        if (this.getId() != null) {
            String id = this.getId();
            for (Group group : groups) {
                if (!id.equalsIgnoreCase(group.getName())) continue;
                return Collections.singletonList(group);
            }
        }
        return groups;
    }

    protected List<Group> queryGroups() {
        UriComponentsBuilder builder = this.prepareQuery("/groups");
        if (this.getMaxResults() >= 0) {
            builder.queryParam("max", new Object[]{this.getMaxResults()});
        }
        if (this.getFirstResult() >= 0) {
            builder.queryParam("first", new Object[]{this.getFirstResult()});
        }
        URI uri = builder.buildAndExpand(new Object[]{this.keycloakConfiguration.getRealm()}).toUri();
        ResponseEntity response = this.keycloakConfiguration.getRestTemplate().exchange(uri, HttpMethod.GET, null, KEYCLOAK_LIST_OF_GROUPS);
        HttpStatus statusCode = response.getStatusCode();
        if (statusCode.is2xxSuccessful()) {
            LOGGER.debug("Successful response from keycloak");
            List keycloakGroups = (List)response.getBody();
            if (keycloakGroups != null) {
                ArrayList<Group> groups = new ArrayList<Group>(keycloakGroups.size());
                for (KeycloakGroupRepresentation keycloakGroup : keycloakGroups) {
                    this.addGroup(groups, keycloakGroup);
                }
                return groups;
            }
            LOGGER.warn("Keycloak didn't return any body when querying groups");
            return Collections.emptyList();
        }
        throw new FlowableException("Keycloak returned status code: " + statusCode);
    }

    protected void addGroup(Collection<Group> groups, KeycloakGroupRepresentation keycloakGroup) {
        GroupEntityImpl group = new GroupEntityImpl();
        group.setId(keycloakGroup.getName());
        group.setName(keycloakGroup.getName());
        groups.add((Group)group);
        List<KeycloakGroupRepresentation> subGroups = keycloakGroup.getSubGroups();
        if (subGroups != null && !subGroups.isEmpty()) {
            for (KeycloakGroupRepresentation subGroup : subGroups) {
                this.addGroup(groups, subGroup);
            }
        }
    }

    protected UriComponentsBuilder prepareQuery(String path) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(this.keycloakConfiguration.getServer() + "auth/admin/realms/{realm}" + path));
        if (this.getUserId() == null && this.getId() != null) {
            builder.queryParam("search", new Object[]{this.getId()});
        }
        return builder;
    }
}

