/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.service;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.GroupQuery;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.idm.service.AbstractIdmService;
import org.flowable.ui.idm.service.GroupService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class GroupServiceImpl
extends AbstractIdmService
implements GroupService {
    @Override
    public List<Group> getGroupsForUser(String userId) {
        return this.identityService.createGroupQuery().groupMember(userId).list();
    }

    @Override
    public List<Group> getGroups(String filter) {
        GroupQuery groupQuery = this.identityService.createGroupQuery();
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            groupQuery.groupNameLikeIgnoreCase("%" + (filter != null ? filter : "") + "%");
        }
        return ((GroupQuery)groupQuery.orderByGroupName().asc()).list();
    }

    @Override
    public Group getGroup(String groupId) {
        return (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
    }

    @Override
    public List<User> getGroupUsers(String groupId, String filter, Integer page, Integer pageSize) {
        int pageValue = page != null ? page : 0;
        int pageSizeValue = pageSize != null ? pageSize : 50;
        UserQuery userQuery = this.createUsersForGroupQuery(groupId, filter);
        return userQuery.listPage(pageValue, pageSizeValue);
    }

    @Override
    public long countTotalGroupUsers(String groupId, String filter, Integer page, Integer pageSize) {
        return this.createUsersForGroupQuery(groupId, filter).count();
    }

    protected UserQuery createUsersForGroupQuery(String groupId, String filter) {
        UserQuery userQuery = (UserQuery)this.identityService.createUserQuery().memberOfGroup(groupId);
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            userQuery.userFullNameLikeIgnoreCase("%" + filter + "%");
        }
        return userQuery;
    }

    @Override
    public Group createNewGroup(String id, String name, String type) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new BadRequestException("Group name required");
        }
        Group newGroup = this.identityService.newGroup(id);
        newGroup.setName(name);
        if (type == null) {
            newGroup.setType("assignment");
        } else {
            newGroup.setType(type);
        }
        this.identityService.saveGroup(newGroup);
        return newGroup;
    }

    @Override
    public Group updateGroupName(String groupId, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new BadRequestException("Group name required");
        }
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            throw new NotFoundException();
        }
        group.setName(name);
        this.identityService.saveGroup(group);
        return group;
    }

    @Override
    public void deleteGroup(String groupId) {
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            throw new NotFoundException();
        }
        this.identityService.deleteGroup(groupId);
    }

    @Override
    public void addGroupMember(String groupId, String userId) {
        this.verifyGroupMemberExists(groupId, userId);
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            throw new NotFoundException();
        }
        User user = (User)((UserQuery)this.identityService.createUserQuery().userId(userId)).singleResult();
        if (user == null) {
            throw new NotFoundException();
        }
        this.identityService.createMembership(userId, groupId);
    }

    @Override
    public void deleteGroupMember(String groupId, String userId) {
        this.verifyGroupMemberExists(groupId, userId);
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            throw new NotFoundException();
        }
        User user = (User)((UserQuery)this.identityService.createUserQuery().userId(userId)).singleResult();
        if (user == null) {
            throw new NotFoundException();
        }
        this.identityService.deleteMembership(userId, groupId);
    }

    protected void verifyGroupMemberExists(String groupId, String userId) {
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        User user = (User)((UserQuery)this.identityService.createUserQuery().userId(userId)).singleResult();
        for (User groupMember : ((UserQuery)this.identityService.createUserQuery().memberOfGroup(groupId)).list()) {
            if (!groupMember.getId().equals(userId)) continue;
            user = groupMember;
        }
        if (group == null || user == null) {
            throw new NotFoundException();
        }
    }
}

