/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.rest.idm.remote;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.flowable.common.engine.api.FlowableIllegalStateException;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.api.User;
import org.flowable.idm.api.UserQuery;
import org.flowable.ui.common.model.GroupRepresentation;
import org.flowable.ui.common.model.RemoteGroup;
import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.rest.idm.CurrentUserProvider;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app", "/"})
public class RemoteAccountResource
implements InitializingBean {
    protected final Collection<CurrentUserProvider> currentUserProviders;
    @Autowired(required=false)
    private RemoteIdmService remoteIdmService;
    @Autowired(required=false)
    private IdmIdentityService identityService;

    public void afterPropertiesSet() {
        if (this.remoteIdmService == null && this.identityService == null) {
            throw new FlowableIllegalStateException("No remoteIdmService or identityService have been provided");
        }
    }

    public RemoteAccountResource(ObjectProvider<CurrentUserProvider> currentUserProviders) {
        this.currentUserProviders = currentUserProviders.orderedStream().collect(Collectors.toList());
    }

    @GetMapping(value={"/rest/account"}, produces={"application/json"})
    public UserRepresentation getAccount(Authentication authentication) {
        UserRepresentation userRepresentation = null;
        for (CurrentUserProvider userProvider : this.currentUserProviders) {
            if (userProvider.supports(authentication)) {
                userRepresentation = userProvider.getCurrentUser(authentication);
            }
            if (userRepresentation == null) continue;
            break;
        }
        if (userRepresentation == null) {
            userRepresentation = this.getCurrentUserRepresentation(authentication.getName());
        }
        if (userRepresentation != null) {
            return userRepresentation;
        }
        throw new NotFoundException();
    }

    protected UserRepresentation getCurrentUserRepresentation(String currentUserId) {
        UserRepresentation userRepresentation = null;
        if (this.remoteIdmService != null) {
            RemoteUser remoteUser = this.remoteIdmService.getUser(currentUserId);
            if (remoteUser != null) {
                userRepresentation = new UserRepresentation(remoteUser);
                if (remoteUser.getGroups() != null && remoteUser.getGroups().size() > 0) {
                    ArrayList<GroupRepresentation> groups = new ArrayList<GroupRepresentation>();
                    for (RemoteGroup remoteGroup : remoteUser.getGroups()) {
                        groups.add(new GroupRepresentation(remoteGroup));
                    }
                    userRepresentation.setGroups(groups);
                }
                if (remoteUser.getPrivileges() != null && remoteUser.getPrivileges().size() > 0) {
                    userRepresentation.setPrivileges(remoteUser.getPrivileges());
                }
            }
        } else {
            User user = (User)((UserQuery)this.identityService.createUserQuery().userId(currentUserId)).singleResult();
            if (user != null) {
                List userPrivileges;
                userRepresentation = new UserRepresentation(user);
                List userGroups = this.identityService.createGroupQuery().groupMember(currentUserId).list();
                if (!userGroups.isEmpty()) {
                    ArrayList<GroupRepresentation> groups = new ArrayList<GroupRepresentation>(userGroups.size());
                    for (Group userGroup : userGroups) {
                        groups.add(new GroupRepresentation(userGroup));
                    }
                    userRepresentation.setGroups(groups);
                }
                if (!(userPrivileges = this.identityService.createPrivilegeQuery().userId(currentUserId).list()).isEmpty()) {
                    userRepresentation.setPrivileges(userPrivileges.stream().map(Privilege::getName).collect(Collectors.toList()));
                }
            }
        }
        return userRepresentation;
    }
}

