/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.rest.idm;

import java.util.Map;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;
import org.flowable.ui.common.model.GroupRepresentation;
import org.flowable.ui.common.model.UserRepresentation;
import org.flowable.ui.common.rest.idm.CurrentUserProvider;
import org.flowable.ui.common.security.SecurityScope;
import org.flowable.ui.common.security.SecurityUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;

public class OAuth2CurrentUserProvider
implements CurrentUserProvider {
    protected String firstNameKey;
    protected String lastNameKey;
    protected String fullNameKey;
    protected String emailKey;

    @Override
    public UserRepresentation getCurrentUser(Authentication authentication) {
        OAuth2User principal = (OAuth2User)authentication.getPrincipal();
        UserRepresentation userRepresentation = principal instanceof OidcUser ? this.getCurrentUser((OidcUser)principal) : this.getCurrentUser(principal);
        SecurityScope securityScope = SecurityUtils.getSecurityScope(authentication);
        userRepresentation.setTenantId(securityScope.getTenantId());
        for (String groupId : securityScope.getGroupIds()) {
            GroupRepresentation group = new GroupRepresentation();
            group.setId(groupId);
            userRepresentation.getGroups().add(group);
        }
        for (GrantedAuthority authority : authentication.getAuthorities()) {
            userRepresentation.getPrivileges().add(authority.getAuthority());
        }
        return userRepresentation;
    }

    protected UserRepresentation getCurrentUser(OidcUser user) {
        Map userAttributes = user.getAttributes();
        UserRepresentation userRepresentation = new UserRepresentation();
        userRepresentation.setId(user.getName());
        userRepresentation.setFirstName(this.getAttribute(this.firstNameKey, userAttributes, user.getGivenName()));
        userRepresentation.setLastName(this.getAttribute(this.lastNameKey, userAttributes, user.getFamilyName()));
        String fullName = this.getAttribute(this.fullNameKey, userAttributes, user.getFullName());
        if (StringUtils.isBlank((CharSequence)fullName)) {
            StringJoiner joiner = new StringJoiner(" ");
            if (StringUtils.isNotBlank((CharSequence)userRepresentation.getFirstName())) {
                joiner.add(userRepresentation.getFirstName());
            }
            if (StringUtils.isNotBlank((CharSequence)user.getMiddleName())) {
                joiner.add(user.getMiddleName());
            }
            if (StringUtils.isNotBlank((CharSequence)userRepresentation.getLastName())) {
                joiner.add(userRepresentation.getLastName());
            }
            fullName = joiner.toString();
        }
        userRepresentation.setFullName(fullName);
        userRepresentation.setEmail(this.getAttribute(this.emailKey, userAttributes, user.getEmail()));
        return userRepresentation;
    }

    protected UserRepresentation getCurrentUser(OAuth2User user) {
        Map userAttributes = user.getAttributes();
        UserRepresentation userRepresentation = new UserRepresentation();
        userRepresentation.setId(user.getName());
        userRepresentation.setFirstName(this.getAttribute(this.firstNameKey, userAttributes, null));
        userRepresentation.setLastName(this.getAttribute(this.lastNameKey, userAttributes, null));
        String fullName = this.getAttribute(this.fullNameKey, userAttributes, null);
        if (StringUtils.isBlank((CharSequence)fullName)) {
            StringJoiner joiner = new StringJoiner(" ");
            if (StringUtils.isNotBlank((CharSequence)userRepresentation.getFirstName())) {
                joiner.add(userRepresentation.getFirstName());
            }
            if (StringUtils.isNotBlank((CharSequence)userRepresentation.getLastName())) {
                joiner.add(userRepresentation.getLastName());
            }
            fullName = joiner.toString();
        }
        userRepresentation.setFullName(fullName);
        userRepresentation.setEmail(this.getAttribute(this.emailKey, userAttributes, null));
        return userRepresentation;
    }

    protected String getAttribute(String attribute, Map<String, Object> attributes, String defaultAttributeValue) {
        if (StringUtils.isEmpty((CharSequence)attribute)) {
            return defaultAttributeValue;
        }
        Object attributeValue = attributes.get(attribute);
        if (attributeValue != null) {
            return attributeValue.toString();
        }
        return defaultAttributeValue;
    }

    @Override
    public boolean supports(Authentication authentication) {
        return authentication.getPrincipal() instanceof OAuth2User;
    }

    public String getFirstNameKey() {
        return this.firstNameKey;
    }

    public void setFirstNameKey(String firstNameKey) {
        this.firstNameKey = firstNameKey;
    }

    public String getLastNameKey() {
        return this.lastNameKey;
    }

    public void setLastNameKey(String lastNameKey) {
        this.lastNameKey = lastNameKey;
    }

    public String getFullNameKey() {
        return this.fullNameKey;
    }

    public void setFullNameKey(String fullNameKey) {
        this.fullNameKey = fullNameKey;
    }

    public String getEmailKey() {
        return this.emailKey;
    }

    public void setEmailKey(String emailKey) {
        this.emailKey = emailKey;
    }
}

