/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskService {
    public static final String HISTORIC_TASK_LIST_URL = "history/historic-task-instances";
    public static final String HISTORIC_TASK_QUERY_URL = "query/historic-task-instances";
    public static final String HISTORIC_TASK_URL = "history/historic-task-instances/{0}";
    public static final String RUNTIME_TASK_URL = "runtime/tasks/{0}";
    public static final String HISTORIC_VARIABLE_INSTANCE_LIST_URL = "history/historic-variable-instances";
    public static final String HISTORIC_TASK_IDENTITY_LINK_LIST_URL = "history/historic-task-instances/{0}/identitylinks";
    public static final String[] TASK_FILTERS = new String[]{"taskNameLike", "taskAssigneeLike", "taskOwner", "finished", "dueDateAfter", "dueDateBefore", "taskCompletedAfter", "taskCompletedBefore", "taskCreatedAfter", "taskCreatedBefore", "parentTaskId", "processInstanceId"};
    private static final String DEFAULT_SUBTASK_RESULT_SIZE = "1024";
    private static final String DEFAULT_VARIABLE_RESULT_SIZE = "1024";
    @Autowired
    protected FlowableClientService clientUtil;
    @Autowired
    protected ObjectMapper objectMapper;

    public JsonNode listTasks(ServerConfig serverConfig, ObjectNode bodyNode) {
        JsonNode resultNode = null;
        try {
            URIBuilder builder = this.clientUtil.createUriBuilder(HISTORIC_TASK_QUERY_URL);
            String uri = this.clientUtil.getUriWithPagingAndOrderParameters(builder, (JsonNode)bodyNode);
            HttpPost post = this.clientUtil.createPost(uri, serverConfig);
            post.setEntity((HttpEntity)this.clientUtil.createStringEntity(bodyNode.toString()));
            resultNode = this.clientUtil.executeRequest((HttpUriRequest)post, serverConfig);
        }
        catch (Exception e) {
            throw new FlowableServiceException(e.getMessage(), e);
        }
        return resultNode;
    }

    public JsonNode getTask(ServerConfig serverConfig, String taskId, boolean runtime) {
        if (taskId == null) {
            throw new IllegalArgumentException("Task id is required");
        }
        URIBuilder builder = null;
        builder = runtime ? this.clientUtil.createUriBuilder(MessageFormat.format(RUNTIME_TASK_URL, taskId)) : this.clientUtil.createUriBuilder(MessageFormat.format(HISTORIC_TASK_URL, taskId));
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public void deleteTask(ServerConfig serverConfig, String taskId) {
        if (taskId == null) {
            throw new IllegalArgumentException("Task id is required");
        }
        JsonNode taskNode = this.getTask(serverConfig, taskId, false);
        if (taskNode.has("endTime")) {
            JsonNode endTimeNode = taskNode.get("endTime");
            if (endTimeNode != null && !endTimeNode.isNull() && StringUtils.isNotEmpty((CharSequence)endTimeNode.asText())) {
                URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(HISTORIC_TASK_URL, taskId));
                HttpDelete delete = new HttpDelete(this.clientUtil.getServerUrl(serverConfig, builder));
                this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)delete, serverConfig, 204);
            } else {
                URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(RUNTIME_TASK_URL, taskId) + "?cascadeHistory=true");
                HttpDelete delete = new HttpDelete(this.clientUtil.getServerUrl(serverConfig, builder));
                this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)delete, serverConfig, 204);
            }
        }
    }

    public void executeTaskAction(ServerConfig serverConfig, String taskId, JsonNode actionRequest) {
        if (taskId == null) {
            throw new IllegalArgumentException("Task id is required");
        }
        URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(RUNTIME_TASK_URL, taskId));
        HttpPost post = this.clientUtil.createPost(builder, serverConfig);
        post.setEntity((HttpEntity)this.clientUtil.createStringEntity(actionRequest));
        this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)post, serverConfig, 200);
    }

    public void updateTask(ServerConfig serverConfig, String taskId, JsonNode actionRequest) {
        if (taskId == null) {
            throw new IllegalArgumentException("Task id is required");
        }
        URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(RUNTIME_TASK_URL, taskId));
        HttpPut put = this.clientUtil.createPut(builder, serverConfig);
        put.setEntity((HttpEntity)this.clientUtil.createStringEntity(actionRequest));
        this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)put, serverConfig, 200);
    }

    public JsonNode getSubTasks(ServerConfig serverConfig, String taskId) {
        URIBuilder builder = this.clientUtil.createUriBuilder(HISTORIC_TASK_LIST_URL);
        builder.addParameter("parentTaskId", taskId);
        builder.addParameter("size", "1024");
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getVariables(ServerConfig serverConfig, String taskId) {
        URIBuilder builder = this.clientUtil.createUriBuilder(HISTORIC_VARIABLE_INSTANCE_LIST_URL);
        builder.addParameter("taskId", taskId);
        builder.addParameter("size", "1024");
        builder.addParameter("sort", "variableName");
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getIdentityLinks(ServerConfig serverConfig, String taskId) {
        URIBuilder builder = this.clientUtil.createUriBuilder(MessageFormat.format(HISTORIC_TASK_IDENTITY_LINK_LIST_URL, taskId));
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }
}

