/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.admin.service.engine;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.flowable.ui.admin.domain.ServerConfig;
import org.flowable.ui.admin.service.engine.FlowableClientService;
import org.flowable.ui.admin.service.engine.exception.FlowableServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BatchService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchService.class);
    @Autowired
    protected FlowableClientService clientUtil;

    public JsonNode listBatches(ServerConfig serverConfig, Map<String, String[]> parameterMap) {
        URIBuilder builder = null;
        try {
            builder = new URIBuilder("management/batches");
        }
        catch (Exception e) {
            LOGGER.error("Error building uri", (Throwable)e);
            throw new FlowableServiceException("Error building uri", e);
        }
        for (String name : parameterMap.keySet()) {
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder.toString()));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getBatch(ServerConfig serverConfig, String batchId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "management/batches/" + batchId));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public String getBatchDocument(ServerConfig serverConfig, String batchId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "management/batches/" + batchId + "/batch-document"));
        return this.clientUtil.executeRequestAsString((HttpUriRequest)get, serverConfig, 200);
    }

    public void deleteBatch(ServerConfig serverConfig, String batchId) {
        HttpDelete post = new HttpDelete(this.clientUtil.getServerUrl(serverConfig, "management/batches/" + batchId));
        this.clientUtil.executeRequestNoResponseBody((HttpUriRequest)post, serverConfig, 204);
    }

    public JsonNode listBatchParts(ServerConfig serverConfig, String batchId, Map<String, String[]> parameterMap) {
        URIBuilder builder = null;
        try {
            builder = new URIBuilder("management/batches/" + batchId + "/batch-parts");
        }
        catch (Exception e) {
            LOGGER.error("Error building uri", (Throwable)e);
            throw new FlowableServiceException("Error building uri", e);
        }
        for (String name : parameterMap.keySet()) {
            builder.addParameter(name, parameterMap.get(name)[0]);
        }
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, builder.toString()));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public JsonNode getBatchPart(ServerConfig serverConfig, String batchPartId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "management/batch-parts/" + batchPartId));
        return this.clientUtil.executeRequest((HttpUriRequest)get, serverConfig);
    }

    public String getBatchPartDocument(ServerConfig serverConfig, String batchPartId) {
        HttpGet get = new HttpGet(this.clientUtil.getServerUrl(serverConfig, "management/batch-parts/" + batchPartId + "/batch-part-document"));
        return this.clientUtil.executeRequestAsString((HttpUriRequest)get, serverConfig, 200);
    }
}

