/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.rest.service.api.repository.BaseProcessDefinitionResource;
import org.flowable.rest.service.api.repository.DecisionResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Process Definitions"}, description="Manage Process Definitions", authorizations={@Authorization(value="basicAuth")})
public class ProcessDefinitionDecisionCollectionResource
extends BaseProcessDefinitionResource {
    @ApiOperation(value="List decisions for a process-definition", nickname="listProcessDefinitionDecisions", tags={"Process Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process definition was found and the decisions are returned.", response=DecisionResponse.class, responseContainer="List"), @ApiResponse(code=404, message="Indicates the requested process definition was not found.")})
    @GetMapping(value={"/repository/process-definitions/{processDefinitionId}/decisions"}, produces={"application/json"})
    public List<DecisionResponse> getDecisionsForProcessDefinition(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId, HttpServletRequest request) {
        ProcessDefinition processDefinition = this.getProcessDefinitionFromRequest(processDefinitionId);
        List decisions = this.repositoryService.getDecisionsForProcessDefinition(processDefinition.getId());
        return this.restResponseFactory.createDecisionResponseList(decisions, processDefinitionId);
    }

    @Deprecated
    @ApiOperation(value="List decision tables for a process-definition", nickname="listProcessDefinitionDecisionTables", tags={"Process Definitions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the process definition was found and the decision tables are returned.", response=DecisionResponse.class, responseContainer="List"), @ApiResponse(code=404, message="Indicates the requested process definition was not found.")})
    @GetMapping(value={"/repository/process-definitions/{processDefinitionId}/decision-tables"}, produces={"application/json"})
    public List<DecisionResponse> getDecisionTablesForProcessDefinition(@ApiParam(name="processDefinitionId") @PathVariable String processDefinitionId, HttpServletRequest request) {
        return this.getDecisionsForProcessDefinition(processDefinitionId, request);
    }
}

