/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.form.api.FormDefinition;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.FormDefinitionQueryImpl;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntityImpl;
import org.flowable.form.engine.impl.persistence.entity.data.AbstractFormDataManager;
import org.flowable.form.engine.impl.persistence.entity.data.FormDefinitionDataManager;

public class MybatisFormDefinitionDataManager
extends AbstractFormDataManager<FormDefinitionEntity>
implements FormDefinitionDataManager {
    public MybatisFormDefinitionDataManager(FormEngineConfiguration formEngineConfiguration) {
        super(formEngineConfiguration);
    }

    public Class<? extends FormDefinitionEntity> getManagedEntityClass() {
        return FormDefinitionEntityImpl.class;
    }

    public FormDefinitionEntity create() {
        return new FormDefinitionEntityImpl();
    }

    @Override
    public FormDefinitionEntity findLatestFormDefinitionByKey(String formDefinitionKey) {
        return (FormDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestFormDefinitionByKey", (Object)formDefinitionKey);
    }

    @Override
    public FormDefinitionEntity findLatestFormDefinitionByKeyAndTenantId(String formDefinitionKey, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("formDefinitionKey", formDefinitionKey);
        params.put("tenantId", tenantId);
        return (FormDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestFormDefinitionByKeyAndTenantId", params);
    }

    @Override
    public FormDefinitionEntity findLatestFormDefinitionByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("formDefinitionKey", formDefinitionKey);
        params.put("parentDeploymentId", parentDeploymentId);
        return (FormDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestFormDefinitionByKeyAndParentDeploymentId", params);
    }

    @Override
    public FormDefinitionEntity findLatestFormDefinitionByKeyParentDeploymentIdAndTenantId(String formDefinitionKey, String parentDeploymentId, String tenantId) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("formDefinitionKey", formDefinitionKey);
        params.put("parentDeploymentId", parentDeploymentId);
        params.put("tenantId", tenantId);
        return (FormDefinitionEntity)this.getDbSqlSession().selectOne("selectLatestFormDefinitionByKeyParentDeploymentIdAndTenantId", params);
    }

    @Override
    public void deleteFormDefinitionsByDeploymentId(String deploymentId) {
        this.getDbSqlSession().delete("deleteFormDefinitionsByDeploymentId", (Object)deploymentId, this.getManagedEntityClass());
    }

    @Override
    public List<FormDefinition> findFormDefinitionsByQueryCriteria(FormDefinitionQueryImpl formQuery) {
        return this.getDbSqlSession().selectList("selectFormDefinitionsByQueryCriteria", (ListQueryParameterObject)formQuery);
    }

    @Override
    public long findFormDefinitionCountByQueryCriteria(FormDefinitionQueryImpl formQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectFormDefinitionCountByQueryCriteria", (Object)formQuery);
    }

    @Override
    public FormDefinitionEntity findFormDefinitionByDeploymentAndKey(String deploymentId, String formDefinitionKey) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("formDefinitionKey", formDefinitionKey);
        return (FormDefinitionEntity)this.getDbSqlSession().selectOne("selectFormDefinitionByDeploymentAndKey", parameters);
    }

    @Override
    public FormDefinitionEntity findFormDefinitionByDeploymentAndKeyAndTenantId(String deploymentId, String formDefinitionKey, String tenantId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("deploymentId", deploymentId);
        parameters.put("formDefinitionKey", formDefinitionKey);
        parameters.put("tenantId", tenantId);
        return (FormDefinitionEntity)this.getDbSqlSession().selectOne("selectFormDefinitionByDeploymentAndKeyAndTenantId", parameters);
    }

    @Override
    public FormDefinitionEntity findFormDefinitionByKeyAndVersion(String formDefinitionKey, Integer formVersion) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formDefinitionKey", formDefinitionKey);
        params.put("formVersion", formVersion);
        List results = this.getDbSqlSession().selectList("selectFormDefinitionsByKeyAndVersion", params);
        if (results.size() == 1) {
            return (FormDefinitionEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " forms with key = '" + formDefinitionKey + "' and version = '" + formVersion + "'.");
        }
        return null;
    }

    @Override
    public FormDefinitionEntity findFormDefinitionByKeyAndVersionAndTenantId(String formDefinitionKey, Integer formVersion, String tenantId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formDefinitionKey", formDefinitionKey);
        params.put("formVersion", formVersion);
        params.put("tenantId", tenantId);
        List results = this.getDbSqlSession().selectList("selectFormDefinitionsByKeyAndVersionAndTenantId", params);
        if (results.size() == 1) {
            return (FormDefinitionEntity)results.get(0);
        }
        if (results.size() > 1) {
            throw new FlowableException("There are " + results.size() + " forms with key = '" + formDefinitionKey + "' and version = '" + formVersion + "'.");
        }
        return null;
    }

    @Override
    public List<FormDefinition> findFormDefinitionsByNativeQuery(Map<String, Object> parameterMap) {
        return this.getDbSqlSession().selectListWithRawParameter("selectFormDefinitionByNativeQuery", parameterMap);
    }

    @Override
    public long findFormDefinitionCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectFormDefinitionCountByNativeQuery", parameterMap);
    }

    @Override
    public void updateFormDefinitionTenantIdForDeployment(String deploymentId, String newTenantId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("deploymentId", deploymentId);
        params.put("tenantId", newTenantId);
        this.getDbSqlSession().directUpdate("updateFormDefinitionTenantIdForDeploymentId", params);
    }
}

