/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.test;

import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.engine.FormEngine;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.test.FormTestHelper;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class FlowableFormRule
implements TestRule {
    protected String configurationResource = "flowable.form.cfg.xml";
    protected String deploymentId;
    protected FormEngineConfiguration formEngineConfiguration;
    protected FormEngine formEngine;
    protected FormRepositoryService repositoryService;

    public FlowableFormRule() {
    }

    public FlowableFormRule(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public FlowableFormRule(FormEngine formEngine) {
        this.setFormEngine(formEngine);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                FlowableFormRule.this.startingQuietly(description, errors);
                try {
                    base.evaluate();
                    FlowableFormRule.this.succeededQuietly(description, errors);
                }
                catch (AssumptionViolatedException e) {
                    errors.add(e);
                    FlowableFormRule.this.skippedQuietly(e, description, errors);
                }
                catch (Throwable t) {
                    errors.add(t);
                    FlowableFormRule.this.failedQuietly(t, description, errors);
                }
                finally {
                    FlowableFormRule.this.finishedQuietly(description, errors);
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private void succeededQuietly(Description description, List<Throwable> errors) {
        try {
            this.succeeded(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void failedQuietly(Throwable t, Description description, List<Throwable> errors) {
        try {
            this.failed(t, description);
        }
        catch (Throwable t1) {
            errors.add(t1);
        }
    }

    private void skippedQuietly(AssumptionViolatedException e, Description description, List<Throwable> errors) {
        try {
            this.skipped(e, description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void startingQuietly(Description description, List<Throwable> errors) {
        try {
            this.starting(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void finishedQuietly(Description description, List<Throwable> errors) {
        try {
            this.finished(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
    }

    protected void starting(Description description) {
        if (this.formEngine == null) {
            this.initializeFormEngine();
        }
        if (this.formEngineConfiguration == null) {
            this.initializeServices();
        }
        this.configureFormEngine();
        try {
            this.deploymentId = FormTestHelper.annotationDeploymentSetUp(this.formEngine, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new FlowableException("Programmatic error: could not instantiate " + description.getClassName(), (Throwable)e);
        }
    }

    protected void initializeFormEngine() {
        this.formEngine = FormTestHelper.getFormEngine(this.configurationResource);
    }

    protected void initializeServices() {
        this.formEngineConfiguration = this.formEngine.getFormEngineConfiguration();
        this.repositoryService = this.formEngine.getFormRepositoryService();
    }

    protected void configureFormEngine() {
    }

    protected void finished(Description description) {
        try {
            FormTestHelper.annotationDeploymentTearDown(this.formEngine, this.deploymentId, Class.forName(description.getClassName()), description.getMethodName());
        }
        catch (ClassNotFoundException e) {
            throw new FlowableException("Programmatic error: could not instantiate " + description.getClassName(), (Throwable)e);
        }
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public FormEngine getFormEngine() {
        return this.formEngine;
    }

    public void setFormEngine(FormEngine formEngine) {
        this.formEngine = formEngine;
        this.initializeServices();
    }

    public FormRepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(FormRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setFormEngineConfiguration(FormEngineConfiguration formEngineConfiguration) {
        this.formEngineConfiguration = formEngineConfiguration;
    }
}

