/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.api.FormDeployment;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormModel;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.FormDeploymentQueryImpl;
import org.flowable.form.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntity;
import org.flowable.form.engine.impl.persistence.entity.FormDefinitionEntityManager;
import org.flowable.form.engine.impl.util.CommandContextUtil;
import org.flowable.form.model.SimpleFormModel;

public class GetFormModelCmd
implements Command<FormInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String formDefinitionKey;
    protected String formDefinitionId;
    protected String tenantId;
    protected String parentDeploymentId;
    protected boolean fallbackToDefaultTenant;

    public GetFormModelCmd(String formDefinitionKey, String formDefinitionId) {
        this.formDefinitionKey = formDefinitionKey;
        this.formDefinitionId = formDefinitionId;
    }

    public GetFormModelCmd(String formDefinitionKey, String formDefinitionId, String tenantId, boolean fallbackToDefaultTenant) {
        this(formDefinitionKey, formDefinitionId);
        this.tenantId = tenantId;
        this.fallbackToDefaultTenant = fallbackToDefaultTenant;
    }

    public GetFormModelCmd(String formDefinitionKey, String formDefinitionId, String tenantId, String parentDeploymentId, boolean fallbackToDefaultTenant) {
        this(formDefinitionKey, formDefinitionId, tenantId, fallbackToDefaultTenant);
        this.parentDeploymentId = parentDeploymentId;
    }

    public FormInfo execute(CommandContext commandContext) {
        List<FormDeployment> formDeployments;
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        DeploymentManager deploymentManager = formEngineConfiguration.getDeploymentManager();
        FormDefinitionEntityManager formDefinitionEntityManager = formEngineConfiguration.getFormDefinitionEntityManager();
        FormDefinitionEntity formDefinitionEntity = null;
        if (this.formDefinitionId != null) {
            formDefinitionEntity = deploymentManager.findDeployedFormDefinitionById(this.formDefinitionId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for id = '" + this.formDefinitionId + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId == null) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKey(this.formDefinitionKey);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId == null) {
            formDefinitionEntity = formDefinitionEntityManager.findLatestFormDefinitionByKeyAndTenantId(this.formDefinitionKey, this.tenantId);
            if (formDefinitionEntity == null && (this.fallbackToDefaultTenant || formEngineConfiguration.isFallbackToDefaultTenant())) {
                formDefinitionEntity = StringUtils.isNotEmpty((CharSequence)formEngineConfiguration.getDefaultTenantValue()) ? formDefinitionEntityManager.findLatestFormDefinitionByKeyAndTenantId(this.formDefinitionKey, formEngineConfiguration.getDefaultTenantValue()) : formDefinitionEntityManager.findLatestFormDefinitionByKey(this.formDefinitionKey);
            }
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for tenant identifier " + this.tenantId, FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId != null) {
            formDeployments = deploymentManager.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new FormDeploymentQueryImpl().parentDeploymentId(this.parentDeploymentId));
            if (formDeployments != null && formDeployments.size() > 0) {
                formDefinitionEntity = formDefinitionEntityManager.findFormDefinitionByDeploymentAndKey(formDeployments.get(0).getId(), this.formDefinitionKey);
            }
            if (formDefinitionEntity == null) {
                formDefinitionEntity = formDefinitionEntityManager.findLatestFormDefinitionByKey(this.formDefinitionKey);
            }
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for parent deployment id " + this.parentDeploymentId, FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId != null) {
            formDeployments = deploymentManager.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new FormDeploymentQueryImpl().parentDeploymentId(this.parentDeploymentId).deploymentTenantId(this.tenantId));
            if (formDeployments != null && formDeployments.size() > 0) {
                formDefinitionEntity = formDefinitionEntityManager.findFormDefinitionByDeploymentAndKeyAndTenantId(formDeployments.get(0).getId(), this.formDefinitionKey, this.tenantId);
            }
            if (formDefinitionEntity == null) {
                formDefinitionEntity = formDefinitionEntityManager.findLatestFormDefinitionByKeyAndTenantId(this.formDefinitionKey, this.tenantId);
            }
            if (formDefinitionEntity == null && (this.fallbackToDefaultTenant || formEngineConfiguration.isFallbackToDefaultTenant())) {
                formDefinitionEntity = StringUtils.isNotEmpty((CharSequence)formEngineConfiguration.getDefaultTenantValue()) ? formDefinitionEntityManager.findLatestFormDefinitionByKeyAndTenantId(this.formDefinitionKey, formEngineConfiguration.getDefaultTenantValue()) : formDefinitionEntityManager.findLatestFormDefinitionByKey(this.formDefinitionKey);
            }
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + " for parent deployment id '" + this.parentDeploymentId + "' and for tenant identifier " + this.tenantId, FormDefinitionEntity.class);
            }
        } else {
            throw new FlowableObjectNotFoundException("formDefinitionKey and formDefinitionId are null");
        }
        FormDefinitionCacheEntry formDefinitionCacheEntry = deploymentManager.resolveFormDefinition(formDefinitionEntity);
        SimpleFormModel formModel = CommandContextUtil.getFormEngineConfiguration(commandContext).getFormJsonConverter().convertToFormModel(formDefinitionCacheEntry.getFormDefinitionJson());
        FormInfo formInfo = new FormInfo();
        formInfo.setId(formDefinitionEntity.getId());
        formInfo.setName(formDefinitionEntity.getName());
        formInfo.setKey(formDefinitionEntity.getKey());
        formInfo.setVersion(formDefinitionEntity.getVersion());
        formInfo.setFormModel((FormModel)formModel);
        return formInfo;
    }
}

