/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.engine.impl.persistence.entity.FormInstanceEntity;
import org.flowable.form.engine.impl.util.CommandContextUtil;

public class GetFormInstanceValuesCmd
implements Command<byte[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String formInstanceId;

    public GetFormInstanceValuesCmd(String formInstanceId) {
        this.formInstanceId = formInstanceId;
    }

    public byte[] execute(CommandContext commandContext) {
        if (this.formInstanceId == null) {
            throw new FlowableIllegalArgumentException("formInstanceId is null");
        }
        FormInstanceEntity formInstance = (FormInstanceEntity)CommandContextUtil.getFormInstanceEntityManager(commandContext).findById(this.formInstanceId);
        if (formInstance != null && formInstance.getFormValuesId() != null) {
            return formInstance.getFormValueBytes();
        }
        return null;
    }
}

