/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.el.VariableContainerWrapper;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.event.EventHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.IOParameterUtil;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.service.impl.persistence.entity.CompensateEventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.job.service.JobService;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSubscriptionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventSubscriptionUtil.class);

    public static void eventReceived(EventSubscriptionEntity eventSubscriptionEntity, Object payload, boolean processAsync) {
        if (processAsync) {
            EventSubscriptionUtil.scheduleEventAsync(eventSubscriptionEntity, payload);
        } else {
            EventSubscriptionUtil.processEventSync(eventSubscriptionEntity, payload);
        }
    }

    public static void processPayloadMap(Object payload, ExecutionEntity execution, FlowNode currentFlowElement, CommandContext commandContext) {
        if (payload instanceof Map) {
            Map payloadMap = (Map)payload;
            if (currentFlowElement instanceof Event) {
                Event event = (Event)currentFlowElement;
                if (event.getInParameters().size() > 0) {
                    VariableContainerWrapper variableWrapper = new VariableContainerWrapper(payloadMap);
                    ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getExpressionManager();
                    IOParameterUtil.processInParameters(event.getInParameters(), (VariableContainer)variableWrapper, (VariableContainer)execution, expressionManager);
                } else {
                    execution.setVariables(payloadMap);
                }
            } else {
                execution.setVariables(payloadMap);
            }
        }
    }

    protected static void processEventSync(EventSubscriptionEntity eventSubscriptionEntity, Object payload) {
        EventHandler eventHandler;
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        if (eventSubscriptionEntity instanceof CompensateEventSubscriptionEntity) {
            processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService().deleteEventSubscription(eventSubscriptionEntity);
            CountingEntityUtil.handleDeleteEventSubscriptionEntityCount((EventSubscription)eventSubscriptionEntity);
        }
        if ((eventHandler = processEngineConfiguration.getEventHandler(eventSubscriptionEntity.getEventType())) == null) {
            throw new FlowableException("Could not find eventhandler for event of type '" + eventSubscriptionEntity.getEventType() + "' for " + eventSubscriptionEntity);
        }
        eventHandler.handleEvent(eventSubscriptionEntity, payload, CommandContextUtil.getCommandContext());
    }

    protected static void scheduleEventAsync(EventSubscriptionEntity eventSubscriptionEntity, Object payload) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        JobService jobService = CommandContextUtil.getJobService(commandContext);
        JobEntity message = jobService.createJob();
        message.setJobType("message");
        message.setJobHandlerType("event");
        message.setElementId(eventSubscriptionEntity.getActivityId());
        message.setJobHandlerConfiguration(eventSubscriptionEntity.getId());
        message.setTenantId(eventSubscriptionEntity.getTenantId());
        String executionId = eventSubscriptionEntity.getExecutionId();
        if (StringUtils.isNotEmpty((CharSequence)executionId)) {
            ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(executionId);
            FlowNode currentFlowElement = (FlowNode)execution.getCurrentFlowElement();
            if (currentFlowElement == null) {
                throw new FlowableException("Error while sending signal for " + eventSubscriptionEntity + " no activity associated with event subscription");
            }
            EventSubscriptionUtil.processPayloadMap(payload, execution, currentFlowElement, commandContext);
        }
        jobService.scheduleAsyncJob(message);
    }
}

