/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.deployer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.event.EventDefinitionExpressionUtil;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CorrelationUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionBuilder;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.SignalEventSubscriptionEntity;

public class EventSubscriptionManager {
    protected void removeObsoleteMessageEventSubscriptions(ProcessDefinitionEntity previousProcessDefinition) {
        if (previousProcessDefinition != null) {
            this.removeObsoleteEventSubscriptions(previousProcessDefinition, "message");
        }
    }

    protected void removeObsoleteSignalEventSubscription(ProcessDefinitionEntity previousProcessDefinition) {
        if (previousProcessDefinition != null) {
            this.removeObsoleteEventSubscriptions(previousProcessDefinition, "signal");
        }
    }

    protected void removeOrUpdateObsoleteEventRegistryEventSubscription(ProcessDefinitionEntity previousProcessDefinition, ProcessDefinitionEntity processDefinition) {
        List<StartEventInfo> eventRegistryStartEvents;
        if (previousProcessDefinition != null && (eventRegistryStartEvents = this.getEventRegistryStartEventEventTypes(previousProcessDefinition)) != null) {
            for (StartEventInfo eventRegistryStartEvent : eventRegistryStartEvents) {
                if (eventRegistryStartEvent.dynamic()) {
                    this.updateOldEventSubscriptions(previousProcessDefinition, processDefinition, eventRegistryStartEvent.eventType(), eventRegistryStartEvent.activityId());
                    continue;
                }
                this.removeObsoleteEventSubscriptions(previousProcessDefinition, eventRegistryStartEvent.eventType());
            }
        }
    }

    protected List<StartEventInfo> getEventRegistryStartEventEventTypes(ProcessDefinitionEntity previousProcessDefinition) {
        ArrayList<StartEventInfo> result = null;
        Process process = ProcessDefinitionUtil.getProcess(previousProcessDefinition.getId());
        List startEvents = process.findFlowElementsOfType(StartEvent.class, true);
        if (!startEvents.isEmpty()) {
            for (StartEvent startEvent : startEvents) {
                List correlationConfiguration;
                String eventType;
                List eventTypeElements;
                if (!CollectionUtil.isEmpty((Collection)startEvent.getEventDefinitions()) || (eventTypeElements = (List)startEvent.getExtensionElements().get("eventType")) == null || eventTypeElements.isEmpty() || !StringUtils.isNotEmpty((CharSequence)(eventType = ((ExtensionElement)eventTypeElements.get(0)).getElementText()))) continue;
                if (result == null) {
                    result = new ArrayList<StartEventInfo>();
                }
                if ((correlationConfiguration = (List)startEvent.getExtensionElements().get("startEventCorrelationConfiguration")) != null && correlationConfiguration.size() > 0 && "manualSubscription".equals(((ExtensionElement)correlationConfiguration.get(0)).getElementText())) {
                    result.add(new StartEventInfo(eventType, startEvent.getId(), true));
                    continue;
                }
                result.add(new StartEventInfo(eventType, startEvent.getId(), false));
            }
        }
        return result;
    }

    protected void removeObsoleteEventSubscriptions(ProcessDefinitionEntity processDefinition, String eventHandlerType) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        List subscriptionsToDelete = eventSubscriptionService.findEventSubscriptionsByTypeAndProcessDefinitionId(eventHandlerType, processDefinition.getId(), processDefinition.getTenantId());
        for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsToDelete) {
            eventSubscriptionService.deleteEventSubscription(eventSubscriptionEntity);
            CountingEntityUtil.handleDeleteEventSubscriptionEntityCount((EventSubscription)eventSubscriptionEntity);
        }
    }

    protected void updateOldEventSubscriptions(ProcessDefinitionEntity previousProcessDefinition, ProcessDefinitionEntity processDefinition, String eventType, String activityId) {
        CommandContext commandContext = Context.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService().updateEventSubscriptionProcessDefinitionId(previousProcessDefinition.getId(), processDefinition.getId(), eventType, activityId, processDefinition.getKey(), null);
    }

    protected void addEventSubscriptions(ProcessDefinitionEntity processDefinition, Process process, BpmnModel bpmnModel) {
        if (CollectionUtil.isNotEmpty((Collection)process.getFlowElements())) {
            for (FlowElement element : process.getFlowElements()) {
                List eventTypeElements;
                if (!(element instanceof StartEvent)) continue;
                StartEvent startEvent = (StartEvent)element;
                if (CollectionUtil.isNotEmpty((Collection)startEvent.getEventDefinitions())) {
                    EventDefinition eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
                    if (eventDefinition instanceof SignalEventDefinition) {
                        SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
                        this.insertSignalEvent(signalEventDefinition, startEvent, processDefinition, bpmnModel);
                        continue;
                    }
                    if (!(eventDefinition instanceof MessageEventDefinition)) continue;
                    MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
                    this.insertMessageEvent(messageEventDefinition, startEvent, processDefinition, bpmnModel);
                    continue;
                }
                if (startEvent.getExtensionElements().get("eventType") == null || (eventTypeElements = (List)startEvent.getExtensionElements().get("eventType")).isEmpty()) continue;
                String eventDefinitionKey = ((ExtensionElement)eventTypeElements.get(0)).getElementText();
                this.insertEventRegistryEvent(eventDefinitionKey, startEvent, processDefinition, bpmnModel);
            }
        }
    }

    protected void insertSignalEvent(SignalEventDefinition signalEventDefinition, StartEvent startEvent, ProcessDefinitionEntity processDefinition, BpmnModel bpmnModel) {
        CommandContext commandContext = Context.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        SignalEventSubscriptionEntity subscriptionEntity = eventSubscriptionService.createSignalEventSubscription();
        String signalName = EventDefinitionExpressionUtil.determineSignalName(commandContext, signalEventDefinition, bpmnModel, null);
        subscriptionEntity.setEventName(signalName);
        subscriptionEntity.setActivityId(startEvent.getId());
        subscriptionEntity.setProcessDefinitionId(processDefinition.getId());
        if (processDefinition.getTenantId() != null) {
            subscriptionEntity.setTenantId(processDefinition.getTenantId());
        }
        eventSubscriptionService.insertEventSubscription((EventSubscriptionEntity)subscriptionEntity);
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)subscriptionEntity);
    }

    protected void insertMessageEvent(MessageEventDefinition messageEventDefinition, StartEvent startEvent, ProcessDefinitionEntity processDefinition, BpmnModel bpmnModel) {
        CommandContext commandContext = Context.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        String messageName = EventDefinitionExpressionUtil.determineMessageName(commandContext, messageEventDefinition, null);
        List subscriptionsForSameMessageName = eventSubscriptionService.findEventSubscriptionsByName("message", messageName, processDefinition.getTenantId());
        for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionsForSameMessageName) {
            if (eventSubscriptionEntity.getProcessInstanceId() != null && !eventSubscriptionEntity.getProcessInstanceId().isEmpty()) continue;
            throw new FlowableException("Cannot deploy process definition '" + processDefinition.getResourceName() + "': there already is a message event subscription for the message with name '" + messageName + "'. For " + eventSubscriptionEntity);
        }
        MessageEventSubscriptionEntity newSubscription = eventSubscriptionService.createMessageEventSubscription();
        newSubscription.setEventName(messageName);
        newSubscription.setActivityId(startEvent.getId());
        newSubscription.setConfiguration(processDefinition.getId());
        newSubscription.setProcessDefinitionId(processDefinition.getId());
        if (processDefinition.getTenantId() != null) {
            newSubscription.setTenantId(processDefinition.getTenantId());
        }
        eventSubscriptionService.insertEventSubscription((EventSubscriptionEntity)newSubscription);
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)newSubscription);
    }

    protected void insertEventRegistryEvent(String eventDefinitionKey, StartEvent startEvent, ProcessDefinitionEntity processDefinition, BpmnModel bpmnModel) {
        List correlationConfiguration = (List)startEvent.getExtensionElements().get("startEventCorrelationConfiguration");
        if (correlationConfiguration != null && correlationConfiguration.size() > 0 && "manualSubscription".equals(((ExtensionElement)correlationConfiguration.get(0)).getElementText())) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        EventSubscriptionBuilder eventSubscriptionBuilder = eventSubscriptionService.createEventSubscriptionBuilder().eventType(eventDefinitionKey).activityId(startEvent.getId()).processDefinitionId(processDefinition.getId()).scopeType("bpmn").configuration(CorrelationUtil.getCorrelationKey("eventCorrelationParameter", commandContext, (FlowElement)startEvent, null));
        if (processDefinition.getTenantId() != null) {
            eventSubscriptionBuilder.tenantId(processDefinition.getTenantId());
        }
        EventSubscription eventSubscription = eventSubscriptionBuilder.create();
        CountingEntityUtil.handleInsertEventSubscriptionEntityCount(eventSubscription);
    }

    protected record StartEventInfo(String eventType, String activityId, boolean dynamic) {
    }
}

