/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;

public class ShellActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected Expression command;
    protected Expression wait;
    protected Expression arg1;
    protected Expression arg2;
    protected Expression arg3;
    protected Expression arg4;
    protected Expression arg5;
    protected Expression outputVariable;
    protected Expression errorCodeVariable;
    protected Expression redirectError;
    protected Expression cleanEnv;
    protected Expression directory;
    String commandStr;
    String arg1Str;
    String arg2Str;
    String arg3Str;
    String arg4Str;
    String arg5Str;
    String waitStr;
    String resultVariableStr;
    String errorCodeVariableStr;
    Boolean waitFlag;
    Boolean redirectErrorFlag;
    Boolean cleanEnvBoolean;
    String directoryStr;

    private void readFields(DelegateExecution execution) {
        this.commandStr = this.getStringFromField(this.command, execution);
        this.arg1Str = this.getStringFromField(this.arg1, execution);
        this.arg2Str = this.getStringFromField(this.arg2, execution);
        this.arg3Str = this.getStringFromField(this.arg3, execution);
        this.arg4Str = this.getStringFromField(this.arg4, execution);
        this.arg5Str = this.getStringFromField(this.arg5, execution);
        this.waitStr = this.getStringFromField(this.wait, execution);
        this.resultVariableStr = this.getStringFromField(this.outputVariable, execution);
        this.errorCodeVariableStr = this.getStringFromField(this.errorCodeVariable, execution);
        String redirectErrorStr = this.getStringFromField(this.redirectError, execution);
        String cleanEnvStr = this.getStringFromField(this.cleanEnv, execution);
        this.waitFlag = this.waitStr == null || "true".equalsIgnoreCase(this.waitStr);
        this.redirectErrorFlag = "true".equalsIgnoreCase(redirectErrorStr);
        this.cleanEnvBoolean = "true".equalsIgnoreCase(cleanEnvStr);
        this.directoryStr = this.getStringFromField(this.directory, execution);
    }

    @Override
    public void execute(DelegateExecution execution) {
        this.readFields(execution);
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(this.commandStr);
        if (this.arg1Str != null) {
            argList.add(this.arg1Str);
        }
        if (this.arg2Str != null) {
            argList.add(this.arg2Str);
        }
        if (this.arg3Str != null) {
            argList.add(this.arg3Str);
        }
        if (this.arg4Str != null) {
            argList.add(this.arg4Str);
        }
        if (this.arg5Str != null) {
            argList.add(this.arg5Str);
        }
        ProcessBuilder processBuilder = new ProcessBuilder(argList);
        try {
            processBuilder.redirectErrorStream(this.redirectErrorFlag);
            if (this.cleanEnvBoolean.booleanValue()) {
                Map<String, String> env = processBuilder.environment();
                env.clear();
            }
            if (this.directoryStr != null && this.directoryStr.length() > 0) {
                processBuilder.directory(new File(this.directoryStr));
            }
            Process process = processBuilder.start();
            if (this.waitFlag.booleanValue()) {
                int errorCode = process.waitFor();
                if (this.resultVariableStr != null) {
                    String result = ShellActivityBehavior.convertStreamToStr(process.getInputStream());
                    execution.setVariable(this.resultVariableStr, result);
                }
                if (this.errorCodeVariableStr != null) {
                    execution.setVariable(this.errorCodeVariableStr, Integer.toString(errorCode));
                }
            }
        }
        catch (Exception e) {
            throw new FlowableException("Could not execute shell command for " + execution, (Throwable)e);
        }
        this.leave(execution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToStr(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            finally {
                is.close();
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    protected String getStringFromField(Expression expression, DelegateExecution execution) {
        Object value;
        if (expression != null && (value = expression.getValue((VariableContainer)execution)) != null) {
            return value.toString();
        }
        return null;
    }
}

