/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cmd.NeedsActiveExecutionCmd;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class EvaluateConditionalEventsCmd
extends NeedsActiveExecutionCmd<Object> {
    private static final long serialVersionUID = 1L;
    protected Map<String, Object> processVariables;
    protected Map<String, Object> transientVariables;
    protected boolean async;

    public EvaluateConditionalEventsCmd(String processInstanceId, Map<String, Object> processVariables) {
        super(processInstanceId);
        this.processVariables = processVariables;
    }

    public EvaluateConditionalEventsCmd(String processInstanceId, Map<String, Object> processVariables, Map<String, Object> transientVariables) {
        this(processInstanceId, processVariables);
        this.transientVariables = transientVariables;
    }

    @Override
    protected Object execute(CommandContext commandContext, ExecutionEntity execution) {
        if (!execution.isProcessInstanceType()) {
            throw new FlowableException("Execution is not of type process instance");
        }
        if (this.processVariables != null) {
            execution.setVariables(this.processVariables);
        }
        if (this.transientVariables != null) {
            execution.setTransientVariables(this.transientVariables);
        }
        CommandContextUtil.getAgenda(commandContext).planEvaluateConditionalEventsOperation(execution);
        return null;
    }

    @Override
    protected String getSuspendedExceptionMessage() {
        return "Cannot evaluate conditions for an execution that is suspended";
    }
}

