/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.json.transformer.AbstractHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.flowable.engine.impl.persistence.entity.HistoricDetailEntityManager;
import org.flowable.engine.impl.persistence.entity.HistoricFormPropertyEntity;
import org.flowable.engine.impl.persistence.entity.data.HistoricDetailDataManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class FormPropertiesSubmittedHistoryJsonTransformer
extends AbstractHistoryJsonTransformer {
    public List<String> getTypes() {
        return Collections.singletonList("form-properties-submitted");
    }

    public boolean isApplicable(ObjectNode historicalData, CommandContext commandContext) {
        HistoricActivityInstanceEntity historicActivityInstance;
        String activityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId");
        return !StringUtils.isNotEmpty((CharSequence)activityId) || (historicActivityInstance = this.findHistoricActivityInstance(commandContext, AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId"), activityId)) != null;
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String propertyId;
        HistoricDetailDataManager historicDetailDataManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoricDetailDataManager();
        int counter = 1;
        while (!StringUtils.isEmpty((CharSequence)(propertyId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)("formPropertyId" + counter))))) {
            HistoricFormPropertyEntity historicFormPropertyEntity = historicDetailDataManager.createHistoricFormProperty();
            historicFormPropertyEntity.setProcessInstanceId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processInstanceId"));
            historicFormPropertyEntity.setExecutionId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId"));
            historicFormPropertyEntity.setTaskId(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"taskId"));
            historicFormPropertyEntity.setPropertyId(propertyId);
            historicFormPropertyEntity.setPropertyValue(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)("formPropertyValue" + counter)));
            historicFormPropertyEntity.setTime(AsyncHistoryJsonUtil.getDateFromJson((ObjectNode)historicalData, (String)"createTime"));
            String activityId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"activityId");
            if (StringUtils.isNotEmpty((CharSequence)activityId)) {
                HistoricActivityInstanceEntity activityInstance = this.findHistoricActivityInstance(commandContext, AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"executionId"), activityId);
                historicFormPropertyEntity.setActivityInstanceId(activityInstance.getId());
            }
            HistoricDetailEntityManager historicDetailEntityManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getHistoricDetailEntityManager();
            historicDetailEntityManager.insert(historicFormPropertyEntity);
            ++counter;
        }
    }
}

