/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.test.profiler;

import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import org.flowable.engine.common.impl.db.BulkDeleteOperation;
import org.flowable.engine.common.impl.db.DbSqlSession;
import org.flowable.engine.common.impl.db.DbSqlSessionFactory;
import org.flowable.engine.common.impl.persistence.cache.EntityCache;
import org.flowable.engine.common.impl.persistence.entity.Entity;
import org.flowable.engine.test.profiler.CommandExecutionResult;
import org.flowable.engine.test.profiler.FlowableProfiler;
import org.flowable.engine.test.profiler.ProfileSession;

public class ProfilingDbSqlSession
extends DbSqlSession {
    protected CommandExecutionResult commandExecutionResult;

    public ProfilingDbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, EntityCache entityCache) {
        super(dbSqlSessionFactory, entityCache);
    }

    public ProfilingDbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, EntityCache entityCache, Connection connection, String catalog, String schema) {
        super(dbSqlSessionFactory, entityCache, connection, catalog, schema);
    }

    public void flush() {
        long startTime = System.currentTimeMillis();
        super.flush();
        long endTime = System.currentTimeMillis();
        CommandExecutionResult commandExecutionResult = this.getCurrentCommandExecution();
        if (commandExecutionResult != null) {
            commandExecutionResult.addDatabaseTime(endTime - startTime);
        }
    }

    public void commit() {
        long startTime = System.currentTimeMillis();
        super.commit();
        long endTime = System.currentTimeMillis();
        CommandExecutionResult commandExecutionResult = this.getCurrentCommandExecution();
        if (commandExecutionResult != null) {
            commandExecutionResult.addDatabaseTime(endTime - startTime);
        }
    }

    public Object selectOne(String statement, Object parameter) {
        if (this.getCurrentCommandExecution() != null) {
            this.getCurrentCommandExecution().addDbSelect(statement);
        }
        return super.selectOne(statement, parameter);
    }

    public <T extends Entity> T selectById(Class<T> entityClass, String id, boolean useCache) {
        if (this.getCurrentCommandExecution() != null) {
            this.getCurrentCommandExecution().addDbSelect("selectById " + entityClass.getName());
        }
        return (T)super.selectById(entityClass, id, useCache);
    }

    public List selectListWithRawParameter(String statement, Object parameter, boolean useCache) {
        if (this.getCurrentCommandExecution() != null) {
            this.getCurrentCommandExecution().addDbSelect(statement);
        }
        return super.selectListWithRawParameter(statement, parameter, useCache);
    }

    public List selectListWithRawParameterNoCacheCheck(String statement, Object parameter) {
        if (this.getCurrentCommandExecution() != null) {
            this.getCurrentCommandExecution().addDbSelect(statement);
        }
        return super.selectListWithRawParameterNoCacheCheck(statement, parameter);
    }

    protected void flushRegularInsert(Entity entity, Class<? extends Entity> clazz) {
        super.flushRegularInsert(entity, clazz);
        if (this.getCurrentCommandExecution() != null) {
            this.getCurrentCommandExecution().addDbInsert(clazz.getName());
        }
    }

    protected void flushBulkInsert(Collection<Entity> entities, Class<? extends Entity> clazz) {
        if (this.getCurrentCommandExecution() != null && entities.size() > 0) {
            this.getCurrentCommandExecution().addDbInsert(clazz.getName() + "-bulk-with-" + entities.size());
        }
        super.flushBulkInsert(entities, clazz);
    }

    protected void flushUpdates() {
        if (this.getCurrentCommandExecution() != null) {
            for (Entity persistentObject : this.updatedObjects) {
                this.getCurrentCommandExecution().addDbUpdate(persistentObject.getClass().getName());
            }
        }
        super.flushUpdates();
    }

    protected void flushDeleteEntities(Class<? extends Entity> entityClass, Collection<Entity> entitiesToDelete) {
        super.flushDeleteEntities(entityClass, entitiesToDelete);
        if (this.getCurrentCommandExecution() != null) {
            for (Entity entity : entitiesToDelete) {
                this.getCurrentCommandExecution().addDbDelete(entity.getClass().getName());
            }
        }
    }

    protected void flushBulkDeletes(Class<? extends Entity> entityClass) {
        if (this.getCurrentCommandExecution() != null && this.bulkDeleteOperations.containsKey(entityClass)) {
            for (BulkDeleteOperation bulkDeleteOperation : (List)this.bulkDeleteOperations.get(entityClass)) {
                this.getCurrentCommandExecution().addDbDelete("Bulk-delete-" + bulkDeleteOperation.getClass());
            }
        }
        super.flushBulkDeletes(entityClass);
    }

    public CommandExecutionResult getCurrentCommandExecution() {
        ProfileSession profileSession;
        if (this.commandExecutionResult == null && (profileSession = FlowableProfiler.getInstance().getCurrentProfileSession()) != null) {
            this.commandExecutionResult = profileSession.getCurrentCommandExecution();
        }
        return this.commandExecutionResult;
    }
}

