/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.persistence.CountingTaskEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.engine.impl.persistence.entity.IdentityLinkEntity;
import org.flowable.engine.impl.persistence.entity.SuspensionState;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.persistence.entity.VariableInitializingList;
import org.flowable.engine.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.engine.impl.persistence.entity.VariableScopeImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.task.DelegationState;
import org.flowable.engine.task.IdentityLink;

public class TaskEntityImpl
extends VariableScopeImpl
implements TaskEntity,
CountingTaskEntity,
Serializable {
    public static final String DELETE_REASON_COMPLETED = "completed";
    public static final String DELETE_REASON_DELETED = "deleted";
    private static final long serialVersionUID = 1L;
    protected String owner;
    protected int assigneeUpdatedCount;
    protected String originalAssignee;
    protected String assignee;
    protected DelegationState delegationState;
    protected String parentTaskId;
    protected String name;
    protected String localizedName;
    protected String description;
    protected String localizedDescription;
    protected int priority = 50;
    protected Date createTime;
    protected Date dueDate;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();
    protected String category;
    protected boolean isIdentityLinksInitialized;
    protected List<IdentityLinkEntity> taskIdentityLinkEntities = new ArrayList<IdentityLinkEntity>();
    protected String executionId;
    protected ExecutionEntity execution;
    protected String processInstanceId;
    protected ExecutionEntity processInstance;
    protected String processDefinitionId;
    protected String taskDefinitionKey;
    protected String formKey;
    protected boolean isDeleted;
    protected boolean isCanceled;
    private boolean isCountEnabled;
    private int variableCount;
    private int identityLinkCount;
    protected String eventName;
    protected FlowableListener currentListener;
    protected String tenantId = "";
    protected List<VariableInstanceEntity> queryVariables;
    protected List<IdentityLinkEntity> queryIdentityLinks;
    protected boolean forcedUpdate;
    protected Date claimTime;

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        persistentState.put("assignee", this.assignee);
        persistentState.put("owner", this.owner);
        persistentState.put("name", this.name);
        persistentState.put("priority", this.priority);
        persistentState.put("category", this.category);
        persistentState.put("formKey", this.formKey);
        if (this.executionId != null) {
            persistentState.put("executionId", this.executionId);
        }
        if (this.processDefinitionId != null) {
            persistentState.put("processDefinitionId", this.processDefinitionId);
        }
        if (this.createTime != null) {
            persistentState.put("createTime", this.createTime);
        }
        if (this.description != null) {
            persistentState.put("description", this.description);
        }
        if (this.dueDate != null) {
            persistentState.put("dueDate", this.dueDate);
        }
        if (this.parentTaskId != null) {
            persistentState.put("parentTaskId", this.parentTaskId);
        }
        if (this.delegationState != null) {
            persistentState.put("delegationState", (Object)this.delegationState);
            persistentState.put("delegationStateString", this.getDelegationStateString());
        }
        persistentState.put("suspensionState", this.suspensionState);
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        if (this.claimTime != null) {
            persistentState.put("claimTime", this.claimTime);
        }
        persistentState.put("isCountEnabled", this.isCountEnabled);
        persistentState.put("variableCount", this.variableCount);
        persistentState.put("identityLinkCount", this.identityLinkCount);
        return persistentState;
    }

    @Override
    public void forceUpdate() {
        this.forcedUpdate = true;
    }

    @Override
    protected VariableScopeImpl getParentVariableScope() {
        if (this.getExecution() != null) {
            return (ExecutionEntityImpl)this.execution;
        }
        return null;
    }

    @Override
    protected void initializeVariableInstanceBackPointer(VariableInstanceEntity variableInstance) {
        variableInstance.setTaskId(this.id);
        variableInstance.setExecutionId(this.executionId);
        variableInstance.setProcessInstanceId(this.processInstanceId);
    }

    protected List<VariableInstanceEntity> loadVariableInstances() {
        return CommandContextUtil.getVariableInstanceEntityManager().findVariableInstancesByTaskId(this.id);
    }

    @Override
    protected VariableInstanceEntity createVariableInstance(String variableName, Object value, ExecutionEntity sourceActivityExecution) {
        VariableInstanceEntity result = super.createVariableInstance(variableName, value, sourceActivityExecution);
        if (CommandContextUtil.getProcessEngineConfiguration() != null && CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createVariableEvent(FlowableEngineEventType.VARIABLE_CREATED, variableName, value, result.getType(), result.getTaskId(), result.getExecutionId(), this.getProcessInstanceId(), this.getProcessDefinitionId()));
        }
        return result;
    }

    @Override
    protected void updateVariableInstance(VariableInstanceEntity variableInstance, Object value, ExecutionEntity sourceActivityExecution) {
        super.updateVariableInstance(variableInstance, value, sourceActivityExecution);
        if (CommandContextUtil.getProcessEngineConfiguration() != null && CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createVariableEvent(FlowableEngineEventType.VARIABLE_UPDATED, variableInstance.getName(), value, variableInstance.getType(), variableInstance.getTaskId(), variableInstance.getExecutionId(), this.getProcessInstanceId(), this.getProcessDefinitionId()));
        }
    }

    @Override
    public ExecutionEntity getExecution() {
        if (this.execution == null && this.executionId != null) {
            this.execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(this.executionId);
        }
        return this.execution;
    }

    @Override
    public void addCandidateUser(String userId) {
        CommandContextUtil.getIdentityLinkEntityManager().addCandidateUser(this, userId);
    }

    @Override
    public void addCandidateUsers(Collection<String> candidateUsers) {
        CommandContextUtil.getIdentityLinkEntityManager().addCandidateUsers(this, candidateUsers);
    }

    @Override
    public void addCandidateGroup(String groupId) {
        CommandContextUtil.getIdentityLinkEntityManager().addCandidateGroup(this, groupId);
    }

    @Override
    public void addCandidateGroups(Collection<String> candidateGroups) {
        CommandContextUtil.getIdentityLinkEntityManager().addCandidateGroups(this, candidateGroups);
    }

    @Override
    public void addUserIdentityLink(String userId, String identityLinkType) {
        CommandContextUtil.getIdentityLinkEntityManager().addUserIdentityLink(this, userId, identityLinkType);
    }

    @Override
    public void addGroupIdentityLink(String groupId, String identityLinkType) {
        CommandContextUtil.getIdentityLinkEntityManager().addGroupIdentityLink(this, groupId, identityLinkType);
    }

    @Override
    public Set<IdentityLink> getCandidates() {
        HashSet<IdentityLink> potentialOwners = new HashSet<IdentityLink>();
        for (IdentityLinkEntity identityLinkEntity : this.getIdentityLinks()) {
            if (!"candidate".equals(identityLinkEntity.getType())) continue;
            potentialOwners.add(identityLinkEntity);
        }
        return potentialOwners;
    }

    @Override
    public void deleteCandidateGroup(String groupId) {
        this.deleteGroupIdentityLink(groupId, "candidate");
    }

    @Override
    public void deleteCandidateUser(String userId) {
        this.deleteUserIdentityLink(userId, "candidate");
    }

    @Override
    public void deleteGroupIdentityLink(String groupId, String identityLinkType) {
        if (groupId != null) {
            CommandContextUtil.getIdentityLinkEntityManager().deleteIdentityLink(this, null, groupId, identityLinkType);
        }
    }

    @Override
    public void deleteUserIdentityLink(String userId, String identityLinkType) {
        if (userId != null) {
            CommandContextUtil.getIdentityLinkEntityManager().deleteIdentityLink(this, userId, null, identityLinkType);
        }
    }

    @Override
    public List<IdentityLinkEntity> getIdentityLinks() {
        if (!this.isIdentityLinksInitialized) {
            this.taskIdentityLinkEntities = this.queryIdentityLinks == null ? CommandContextUtil.getIdentityLinkEntityManager().findIdentityLinksByTaskId(this.id) : this.queryIdentityLinks;
            this.isIdentityLinksInitialized = true;
        }
        return this.taskIdentityLinkEntities;
    }

    @Override
    public void setExecutionVariables(Map<String, Object> parameters) {
        if (this.getExecution() != null) {
            this.execution.setVariables(parameters);
        }
    }

    @Override
    public void setName(String taskName) {
        this.name = taskName;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setAssignee(String assignee) {
        this.originalAssignee = this.assignee;
        this.assignee = assignee;
        ++this.assigneeUpdatedCount;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public void setParentTaskId(String parentTaskId) {
        this.parentTaskId = parentTaskId;
    }

    @Override
    public String getFormKey() {
        return this.formKey;
    }

    @Override
    public void setFormKey(String formKey) {
        this.formKey = formKey;
    }

    @Override
    protected boolean isActivityIdUsedForDetails() {
        return false;
    }

    @Override
    protected VariableInstanceEntity getSpecificVariable(String variableName) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new FlowableException("lazy loading outside command context");
        }
        VariableInstanceEntity variableInstance = CommandContextUtil.getVariableInstanceEntityManager(commandContext).findVariableInstanceByTaskAndName(this.id, variableName);
        return variableInstance;
    }

    @Override
    protected List<VariableInstanceEntity> getSpecificVariables(Collection<String> variableNames) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null) {
            throw new FlowableException("lazy loading outside command context");
        }
        return CommandContextUtil.getVariableInstanceEntityManager(commandContext).findVariableInstancesByTaskAndNames(this.id, variableNames);
    }

    @Override
    public String getName() {
        if (this.localizedName != null && this.localizedName.length() > 0) {
            return this.localizedName;
        }
        return this.name;
    }

    public String getLocalizedName() {
        return this.localizedName;
    }

    @Override
    public void setLocalizedName(String localizedName) {
        this.localizedName = localizedName;
    }

    @Override
    public String getDescription() {
        if (this.localizedDescription != null && this.localizedDescription.length() > 0) {
            return this.localizedDescription;
        }
        return this.description;
    }

    public String getLocalizedDescription() {
        return this.localizedDescription;
    }

    @Override
    public void setLocalizedDescription(String localizedDescription) {
        this.localizedDescription = localizedDescription;
    }

    @Override
    public Date getDueDate() {
        return this.dueDate;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @Override
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @Override
    public String getAssignee() {
        return this.assignee;
    }

    public String getOriginalAssignee() {
        if (this.assigneeUpdatedCount > 1) {
            return this.originalAssignee;
        }
        return this.assignee;
    }

    @Override
    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    @Override
    public void setTaskDefinitionKey(String taskDefinitionKey) {
        this.taskDefinitionKey = taskDefinitionKey;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    @Override
    public FlowableListener getCurrentFlowableListener() {
        return this.currentListener;
    }

    @Override
    public void setCurrentFlowableListener(FlowableListener currentListener) {
        this.currentListener = currentListener;
    }

    @Override
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public ExecutionEntity getProcessInstance() {
        if (this.processInstance == null && this.processInstanceId != null) {
            this.processInstance = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager().findById(this.processInstanceId);
        }
        return this.processInstance;
    }

    public void setProcessInstance(ExecutionEntity processInstance) {
        this.processInstance = processInstance;
    }

    @Override
    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
    }

    @Override
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    @Override
    public void setDelegationState(DelegationState delegationState) {
        this.delegationState = delegationState;
    }

    public String getDelegationStateString() {
        return this.delegationState != null ? this.delegationState.toString() : null;
    }

    public void setDelegationStateString(String delegationStateString) {
        this.delegationState = delegationStateString != null ? DelegationState.valueOf(DelegationState.class, delegationStateString) : null;
    }

    @Override
    public boolean isDeleted() {
        return this.isDeleted;
    }

    @Override
    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    @Override
    public String getParentTaskId() {
        return this.parentTaskId;
    }

    @Override
    public Map<String, VariableInstanceEntity> getVariableInstanceEntities() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances;
    }

    @Override
    public int getSuspensionState() {
        return this.suspensionState;
    }

    @Override
    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }

    @Override
    public Map<String, Object> getTaskLocalVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() == null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    @Override
    public Map<String, Object> getProcessVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        if (this.queryVariables != null) {
            for (VariableInstanceEntity variableInstance : this.queryVariables) {
                if (variableInstance.getId() == null || variableInstance.getTaskId() != null) continue;
                variables.put(variableInstance.getName(), variableInstance.getValue());
            }
        }
        return variables;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public List<VariableInstanceEntity> getQueryVariables() {
        if (this.queryVariables == null && Context.getCommandContext() != null) {
            this.queryVariables = new VariableInitializingList();
        }
        return this.queryVariables;
    }

    public void setQueryVariables(List<VariableInstanceEntity> queryVariables) {
        this.queryVariables = queryVariables;
    }

    public List<IdentityLinkEntity> getQueryIdentityLinks() {
        if (this.queryIdentityLinks == null) {
            this.queryIdentityLinks = new LinkedList<IdentityLinkEntity>();
        }
        return this.queryIdentityLinks;
    }

    public void setQueryIdentityLinks(List<IdentityLinkEntity> identityLinks) {
        this.queryIdentityLinks = identityLinks;
    }

    @Override
    public Date getClaimTime() {
        return this.claimTime;
    }

    @Override
    public void setClaimTime(Date claimTime) {
        this.claimTime = claimTime;
    }

    public String toString() {
        return "Task[id=" + this.id + ", name=" + this.name + "]";
    }

    @Override
    public boolean isCountEnabled() {
        return this.isCountEnabled;
    }

    @Override
    public void setCountEnabled(boolean isCountEnabled) {
        this.isCountEnabled = isCountEnabled;
    }

    @Override
    public void setVariableCount(int variableCount) {
        this.variableCount = variableCount;
    }

    @Override
    public int getVariableCount() {
        return this.variableCount;
    }

    @Override
    public void setIdentityLinkCount(int identityLinkCount) {
        this.identityLinkCount = identityLinkCount;
    }

    @Override
    public int getIdentityLinkCount() {
        return this.identityLinkCount;
    }
}

