/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.history.async.AsyncHistoryJobNotApplicableException;
import org.flowable.engine.impl.jobexecutor.HistoryJobHandler;
import org.flowable.engine.impl.persistence.entity.HistoryJobEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public abstract class AbstractAsyncHistoryJobHandler
implements HistoryJobHandler {
    protected boolean isAsyncHistoryJsonGroupingEnabled;

    @Override
    public void execute(HistoryJobEntity job, String configuration, CommandContext commandContext) {
        ObjectMapper objectMapper = CommandContextUtil.getProcessEngineConfiguration(commandContext).getObjectMapper();
        if (job.getAdvancedJobHandlerConfigurationByteArrayRef() != null) {
            try {
                byte[] bytes = this.getJobBytes(job);
                JsonNode historyNode = objectMapper.readTree(bytes);
                if (this.isAsyncHistoryJsonGroupingEnabled() && historyNode.isArray()) {
                    ArrayNode arrayNode = (ArrayNode)historyNode;
                    for (JsonNode jsonNode : arrayNode) {
                        this.processHistoryJson(commandContext, job, jsonNode);
                    }
                } else {
                    this.processHistoryJson(commandContext, job, historyNode);
                }
            }
            catch (AsyncHistoryJobNotApplicableException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FlowableException("Could not deserialize async history json for job (id=" + job.getId() + ")", (Throwable)e);
            }
        }
    }

    protected byte[] getJobBytes(HistoryJobEntity job) {
        return job.getAdvancedJobHandlerConfigurationByteArrayRef().getBytes();
    }

    protected abstract void processHistoryJson(CommandContext var1, HistoryJobEntity var2, JsonNode var3);

    public boolean isAsyncHistoryJsonGroupingEnabled() {
        return this.isAsyncHistoryJsonGroupingEnabled;
    }

    public void setAsyncHistoryJsonGroupingEnabled(boolean isAsyncHistoryJsonGroupingEnabled) {
        this.isAsyncHistoryJsonGroupingEnabled = isAsyncHistoryJsonGroupingEnabled;
    }
}

