/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history;

import java.util.Date;
import java.util.List;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.engine.common.impl.cfg.IdGenerator;
import org.flowable.engine.common.impl.persistence.cache.EntityCache;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.history.HistoryManager;
import org.flowable.engine.impl.identity.Authentication;
import org.flowable.engine.impl.persistence.AbstractManager;
import org.flowable.engine.impl.persistence.entity.CommentEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHistoryManager
extends AbstractManager
implements HistoryManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractHistoryManager.class.getName());
    protected HistoryLevel historyLevel;

    public AbstractHistoryManager(ProcessEngineConfigurationImpl processEngineConfiguration, HistoryLevel historyLevel) {
        super(processEngineConfiguration);
        this.historyLevel = historyLevel;
    }

    @Override
    public boolean isHistoryLevelAtLeast(HistoryLevel level) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current history level: {}, level required: {}", (Object)this.historyLevel, (Object)level);
        }
        return this.historyLevel.isAtLeast(level);
    }

    @Override
    public boolean isHistoryEnabled() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Current history level: {}", (Object)this.historyLevel);
        }
        return this.historyLevel != HistoryLevel.NONE;
    }

    @Override
    public void createIdentityLinkComment(String taskId, String userId, String groupId, String type, boolean create) {
        this.createIdentityLinkComment(taskId, userId, groupId, type, create, false);
    }

    @Override
    public void createUserIdentityLinkComment(String taskId, String userId, String type, boolean create) {
        this.createIdentityLinkComment(taskId, userId, null, type, create, false);
    }

    @Override
    public void createGroupIdentityLinkComment(String taskId, String groupId, String type, boolean create) {
        this.createIdentityLinkComment(taskId, null, groupId, type, create, false);
    }

    @Override
    public void createUserIdentityLinkComment(String taskId, String userId, String type, boolean create, boolean forceNullUserId) {
        this.createIdentityLinkComment(taskId, userId, null, type, create, forceNullUserId);
    }

    @Override
    public void createIdentityLinkComment(String taskId, String userId, String groupId, String type, boolean create, boolean forceNullUserId) {
        if (this.isHistoryEnabled()) {
            String authenticatedUserId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = (CommentEntity)this.getCommentEntityManager().create();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(this.getClock().getCurrentTime());
            comment.setTaskId(taskId);
            if (userId != null || forceNullUserId) {
                if (create && !forceNullUserId) {
                    comment.setAction("AddUserLink");
                } else {
                    comment.setAction("DeleteUserLink");
                }
                comment.setMessage(new String[]{userId, type});
            } else {
                if (create) {
                    comment.setAction("AddGroupLink");
                } else {
                    comment.setAction("DeleteGroupLink");
                }
                comment.setMessage(new String[]{groupId, type});
            }
            this.getCommentEntityManager().insert(comment);
        }
    }

    @Override
    public void createProcessInstanceIdentityLinkComment(String processInstanceId, String userId, String groupId, String type, boolean create) {
        this.createProcessInstanceIdentityLinkComment(processInstanceId, userId, groupId, type, create, false);
    }

    @Override
    public void createProcessInstanceIdentityLinkComment(String processInstanceId, String userId, String groupId, String type, boolean create, boolean forceNullUserId) {
        if (this.isHistoryEnabled()) {
            String authenticatedUserId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = (CommentEntity)this.getCommentEntityManager().create();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(this.getClock().getCurrentTime());
            comment.setProcessInstanceId(processInstanceId);
            if (userId != null || forceNullUserId) {
                if (create && !forceNullUserId) {
                    comment.setAction("AddUserLink");
                } else {
                    comment.setAction("DeleteUserLink");
                }
                comment.setMessage(new String[]{userId, type});
            } else {
                if (create) {
                    comment.setAction("AddGroupLink");
                } else {
                    comment.setAction("DeleteGroupLink");
                }
                comment.setMessage(new String[]{groupId, type});
            }
            this.getCommentEntityManager().insert(comment);
        }
    }

    @Override
    public void createAttachmentComment(String taskId, String processInstanceId, String attachmentName, boolean create) {
        if (this.isHistoryEnabled()) {
            String userId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = (CommentEntity)this.getCommentEntityManager().create();
            comment.setUserId(userId);
            comment.setType("event");
            comment.setTime(this.getClock().getCurrentTime());
            comment.setTaskId(taskId);
            comment.setProcessInstanceId(processInstanceId);
            if (create) {
                comment.setAction("AddAttachment");
            } else {
                comment.setAction("DeleteAttachment");
            }
            comment.setMessage(attachmentName);
            this.getCommentEntityManager().insert(comment);
        }
    }

    protected HistoricActivityInstanceEntity getHistoricActivityInstanceFromCache(String executionId, String activityId, boolean endTimeMustBeNull) {
        List cachedHistoricActivityInstances = this.getEntityCache().findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
            if (activityId == null || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || endTimeMustBeNull && cachedHistoricActivityInstance.getEndTime() != null || !executionId.equals(cachedHistoricActivityInstance.getExecutionId())) continue;
            return cachedHistoricActivityInstance;
        }
        return null;
    }

    @Override
    public HistoricActivityInstanceEntity findActivityInstance(ExecutionEntity execution, boolean createOnNotFound, boolean endTimeMustBeNull) {
        String activityId = this.getActivityIdForExecution(execution);
        return activityId != null ? this.findActivityInstance(execution, activityId, createOnNotFound, endTimeMustBeNull) : null;
    }

    protected String getActivityIdForExecution(ExecutionEntity execution) {
        String activityId = null;
        if (execution.getCurrentFlowElement() instanceof FlowNode) {
            activityId = execution.getCurrentFlowElement().getId();
        } else if (execution.getCurrentFlowElement() instanceof SequenceFlow && execution.getCurrentFlowableListener() == null) {
            activityId = ((SequenceFlow)execution.getCurrentFlowElement()).getSourceFlowElement().getId();
        }
        return activityId;
    }

    protected HistoricActivityInstanceEntity findActivityInstance(ExecutionEntity execution, String activityId, boolean createOnNotFound, boolean endTimeMustBeNull) {
        List<HistoricActivityInstanceEntity> historicActivityInstances;
        if (activityId == null) {
            return null;
        }
        String executionId = execution.getId();
        HistoricActivityInstanceEntity historicActivityInstanceEntityFromCache = this.getHistoricActivityInstanceFromCache(executionId, activityId, endTimeMustBeNull);
        if (historicActivityInstanceEntityFromCache != null) {
            return historicActivityInstanceEntityFromCache;
        }
        if (!execution.isInserted() && !execution.isProcessInstanceType() && (historicActivityInstances = this.getHistoricActivityInstanceEntityManager().findUnfinishedHistoricActivityInstancesByExecutionAndActivityId(executionId, activityId)).size() > 0) {
            return historicActivityInstances.get(0);
        }
        if (createOnNotFound && (execution.getCurrentFlowElement() != null && execution.getCurrentFlowElement() instanceof FlowNode || execution.getCurrentFlowElement() == null)) {
            return this.createHistoricActivityInstanceEntity(execution);
        }
        return null;
    }

    protected HistoricActivityInstanceEntity createHistoricActivityInstanceEntity(ExecutionEntity execution) {
        IdGenerator idGenerator = this.getProcessEngineConfiguration().getIdGenerator();
        String processDefinitionId = execution.getProcessDefinitionId();
        String processInstanceId = execution.getProcessInstanceId();
        HistoricActivityInstanceEntity historicActivityInstance = (HistoricActivityInstanceEntity)this.getHistoricActivityInstanceEntityManager().create();
        historicActivityInstance.setId(idGenerator.getNextId());
        historicActivityInstance.setProcessDefinitionId(processDefinitionId);
        historicActivityInstance.setProcessInstanceId(processInstanceId);
        historicActivityInstance.setExecutionId(execution.getId());
        historicActivityInstance.setActivityId(execution.getActivityId());
        if (execution.getCurrentFlowElement() != null) {
            historicActivityInstance.setActivityName(execution.getCurrentFlowElement().getName());
            historicActivityInstance.setActivityType(this.parseActivityType(execution.getCurrentFlowElement()));
        }
        Date now = this.getClock().getCurrentTime();
        historicActivityInstance.setStartTime(now);
        if (execution.getTenantId() != null) {
            historicActivityInstance.setTenantId(execution.getTenantId());
        }
        this.getHistoricActivityInstanceEntityManager().insert(historicActivityInstance);
        return historicActivityInstance;
    }

    protected String parseActivityType(FlowElement element) {
        String elementType = element.getClass().getSimpleName();
        elementType = elementType.substring(0, 1).toLowerCase() + elementType.substring(1);
        return elementType;
    }

    protected EntityCache getEntityCache() {
        return this.getSession(EntityCache.class);
    }

    public HistoryLevel getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(HistoryLevel historyLevel) {
        this.historyLevel = historyLevel;
    }
}

