/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.List;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.HistoryJobQueryImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.HistoryJob;

public class UnacquireOwnedHistoryJobsCmd
implements Command<Void> {
    private final String lockOwner;
    private final String tenantId;

    public UnacquireOwnedHistoryJobsCmd(String lockOwner, String tenantId) {
        this.lockOwner = lockOwner;
        this.tenantId = tenantId;
    }

    public Void execute(CommandContext commandContext) {
        HistoryJobQueryImpl jobQuery = new HistoryJobQueryImpl(commandContext);
        jobQuery.lockOwner(this.lockOwner);
        jobQuery.jobTenantId(this.tenantId);
        List<HistoryJob> jobs = CommandContextUtil.getHistoryJobEntityManager(commandContext).findHistoryJobsByQueryCriteria(jobQuery);
        for (HistoryJob job : jobs) {
            CommandContextUtil.getJobManager(commandContext).unacquire(job);
        }
        return null;
    }
}

