/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Map;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.task.DelegationState;

public class ResolveTaskCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;

    public ResolveTaskCmd(String taskId, Map<String, Object> variables) {
        super(taskId);
        this.variables = variables;
    }

    public ResolveTaskCmd(String taskId, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this(taskId, variables);
        this.transientVariables = transientVariables;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        if (this.variables != null) {
            task.setVariables(this.variables);
        }
        if (this.transientVariables != null) {
            task.setTransientVariables(this.transientVariables);
        }
        task.setDelegationState(DelegationState.RESOLVED);
        CommandContextUtil.getTaskEntityManager(commandContext).changeTaskAssignee(task, task.getOwner());
        return null;
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot resolve a suspended task";
    }
}

