/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.JobNotFoundException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.DeadLetterJobEntity;
import org.flowable.engine.impl.persistence.entity.JobEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveDeadLetterJobToExecutableJobCmd
implements Command<JobEntity>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MoveDeadLetterJobToExecutableJobCmd.class);
    protected String jobId;
    protected int retries;

    public MoveDeadLetterJobToExecutableJobCmd(String jobId, int retries) {
        this.jobId = jobId;
        this.retries = retries;
    }

    public JobEntity execute(CommandContext commandContext) {
        if (this.jobId == null) {
            throw new FlowableIllegalArgumentException("jobId and job is null");
        }
        DeadLetterJobEntity job = (DeadLetterJobEntity)CommandContextUtil.getDeadLetterJobEntityManager(commandContext).findById(this.jobId);
        if (job == null) {
            throw new JobNotFoundException(this.jobId);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Moving deadletter job to executable job table {}", (Object)job.getId());
        }
        return CommandContextUtil.getJobManager(commandContext).moveDeadLetterJobToExecutableJob(job, this.retries);
    }

    public String getJobId() {
        return this.jobId;
    }
}

