/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.history.HistoricIdentityLink;
import org.flowable.engine.history.HistoricTaskInstance;
import org.flowable.engine.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.flowable.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.engine.impl.util.CommandContextUtil;

public class GetHistoricIdentityLinksForTaskCmd
implements Command<List<HistoricIdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String processInstanceId;

    public GetHistoricIdentityLinksForTaskCmd(String taskId, String processInstanceId) {
        if (taskId == null && processInstanceId == null) {
            throw new FlowableIllegalArgumentException("taskId or processInstanceId is required");
        }
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
    }

    public List<HistoricIdentityLink> execute(CommandContext commandContext) {
        if (this.taskId != null) {
            return this.getLinksForTask(commandContext);
        }
        return this.getLinksForProcessInstance(commandContext);
    }

    protected List<HistoricIdentityLink> getLinksForTask(CommandContext commandContext) {
        HistoricIdentityLinkEntity identityLink;
        HistoricTaskInstanceEntity task = (HistoricTaskInstanceEntity)CommandContextUtil.getHistoricTaskInstanceEntityManager(commandContext).findById(this.taskId);
        if (task == null) {
            throw new FlowableObjectNotFoundException("No historic task exists with the given id: " + this.taskId, HistoricTaskInstance.class);
        }
        List<HistoricIdentityLink> identityLinks = CommandContextUtil.getHistoricIdentityLinkEntityManager(commandContext).findHistoricIdentityLinksByTaskId(this.taskId);
        HistoricIdentityLink assigneeIdentityLink = null;
        HistoricIdentityLink ownerIdentityLink = null;
        for (HistoricIdentityLink historicIdentityLink : identityLinks) {
            if ("assignee".equals(historicIdentityLink.getType())) {
                assigneeIdentityLink = historicIdentityLink;
                continue;
            }
            if (!"owner".equals(historicIdentityLink.getType())) continue;
            ownerIdentityLink = historicIdentityLink;
        }
        if (task.getAssignee() != null && assigneeIdentityLink == null) {
            identityLink = (HistoricIdentityLinkEntity)CommandContextUtil.getHistoricIdentityLinkEntityManager(commandContext).create();
            identityLink.setUserId(task.getAssignee());
            identityLink.setTaskId(task.getId());
            identityLink.setType("assignee");
            identityLinks.add(identityLink);
        }
        if (task.getOwner() != null && ownerIdentityLink == null) {
            identityLink = (HistoricIdentityLinkEntity)CommandContextUtil.getHistoricIdentityLinkEntityManager(commandContext).create();
            identityLink.setTaskId(task.getId());
            identityLink.setUserId(task.getOwner());
            identityLink.setType("owner");
            identityLinks.add(identityLink);
        }
        return identityLinks;
    }

    protected List<HistoricIdentityLink> getLinksForProcessInstance(CommandContext commandContext) {
        return CommandContextUtil.getHistoricIdentityLinkEntityManager(commandContext).findHistoricIdentityLinksByProcessInstanceId(this.processInstanceId);
    }
}

