/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.persistence.entity.SuspendedJobEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteSuspendedJobCmd
implements Command<Object>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteSuspendedJobCmd.class);
    private static final long serialVersionUID = 1L;
    protected String suspendedJobId;

    public DeleteSuspendedJobCmd(String suspendedJobId) {
        this.suspendedJobId = suspendedJobId;
    }

    public Object execute(CommandContext commandContext) {
        SuspendedJobEntity jobToDelete = this.getJobToDelete(commandContext);
        this.sendCancelEvent(jobToDelete);
        CommandContextUtil.getSuspendedJobEntityManager(commandContext).delete(jobToDelete);
        return null;
    }

    protected void sendCancelEvent(SuspendedJobEntity jobToDelete) {
        if (CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, jobToDelete));
        }
    }

    protected SuspendedJobEntity getJobToDelete(CommandContext commandContext) {
        SuspendedJobEntity job;
        if (this.suspendedJobId == null) {
            throw new FlowableIllegalArgumentException("jobId is null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleting job {}", (Object)this.suspendedJobId);
        }
        if ((job = (SuspendedJobEntity)CommandContextUtil.getSuspendedJobEntityManager(commandContext).findById(this.suspendedJobId)) == null) {
            throw new FlowableObjectNotFoundException("No suspended job found with id '" + this.suspendedJobId + "'", Job.class);
        }
        return job;
    }
}

