/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.persistence.entity.CommentEntity;
import org.flowable.engine.impl.persistence.entity.CommentEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.task.Comment;
import org.flowable.engine.task.Task;

public class DeleteCommentCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;
    protected String processInstanceId;
    protected String commentId;

    public DeleteCommentCmd(String taskId, String processInstanceId, String commentId) {
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.commentId = commentId;
    }

    public Void execute(CommandContext commandContext) {
        CommentEntityManager commentManager = CommandContextUtil.getCommentEntityManager(commandContext);
        if (this.commentId != null) {
            Task task;
            Comment comment = commentManager.findComment(this.commentId);
            if (comment == null) {
                throw new FlowableObjectNotFoundException("Comment with id '" + this.commentId + "' doesn't exists.", Comment.class);
            }
            if (comment.getProcessInstanceId() != null) {
                ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(comment.getProcessInstanceId());
                if (execution != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
                    Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                    compatibilityHandler.deleteComment(this.commentId, this.taskId, this.processInstanceId);
                    return null;
                }
            } else if (comment.getTaskId() != null && (task = (Task)CommandContextUtil.getTaskEntityManager(commandContext).findById(comment.getTaskId())) != null && task.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.deleteComment(this.commentId, this.taskId, this.processInstanceId);
                return null;
            }
            commentManager.delete((CommentEntity)comment);
        } else {
            ArrayList<Comment> comments = new ArrayList<Comment>();
            if (this.processInstanceId != null) {
                ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(this.processInstanceId);
                if (execution != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
                    Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                    compatibilityHandler.deleteComment(this.commentId, this.taskId, this.processInstanceId);
                    return null;
                }
                comments.addAll(commentManager.findCommentsByProcessInstanceId(this.processInstanceId));
            }
            if (this.taskId != null) {
                Task task = (Task)CommandContextUtil.getTaskEntityManager(commandContext).findById(this.taskId);
                if (task != null && task.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, task.getProcessDefinitionId())) {
                    Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                    compatibilityHandler.deleteComment(this.commentId, this.taskId, this.processInstanceId);
                    return null;
                }
                comments.addAll(commentManager.findCommentsByTaskId(this.taskId));
            }
            for (Comment comment : comments) {
                commentManager.delete((CommentEntity)comment);
            }
        }
        return null;
    }
}

