/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.GregorianCalendar;
import java.util.List;
import org.flowable.engine.common.impl.Page;
import org.flowable.engine.common.impl.interceptor.Command;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.impl.asyncexecutor.AcquiredJobEntities;
import org.flowable.engine.impl.asyncexecutor.AsyncExecutor;
import org.flowable.engine.impl.persistence.entity.JobInfoEntity;
import org.flowable.engine.impl.persistence.entity.JobInfoEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;

public class AcquireJobsCmd
implements Command<AcquiredJobEntities> {
    private final AsyncExecutor asyncExecutor;
    private final int remainingCapacity;
    private final JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;

    public AcquireJobsCmd(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
        this.remainingCapacity = Integer.MAX_VALUE;
        this.jobEntityManager = asyncExecutor.getProcessEngineConfiguration().getJobEntityManager();
    }

    public AcquireJobsCmd(AsyncExecutor asyncExecutor, int remainingCapacity, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        this.asyncExecutor = asyncExecutor;
        this.remainingCapacity = remainingCapacity;
        this.jobEntityManager = jobEntityManager;
    }

    public AcquiredJobEntities execute(CommandContext commandContext) {
        int maxResults = Math.min(this.remainingCapacity, this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition());
        List<? extends JobInfoEntity> jobs = this.jobEntityManager.findJobsToExecute(new Page(0, maxResults));
        AcquiredJobEntities acquiredJobs = new AcquiredJobEntities();
        for (JobInfoEntity jobInfoEntity : jobs) {
            this.lockJob(commandContext, jobInfoEntity, this.asyncExecutor.getAsyncJobLockTimeInMillis());
            acquiredJobs.addJob(jobInfoEntity);
        }
        return acquiredJobs;
    }

    protected void lockJob(CommandContext commandContext, JobInfoEntity job, int lockTimeInMillis) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(CommandContextUtil.getProcessEngineConfiguration(commandContext).getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockOwner(this.asyncExecutor.getLockOwner());
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }
}

