/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.deployer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.engine.DynamicBpmnService;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.cfg.IdGenerator;
import org.flowable.engine.common.impl.context.Context;
import org.flowable.engine.common.impl.interceptor.CommandContext;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.bpmn.deployer.BpmnDeploymentHelper;
import org.flowable.engine.impl.bpmn.deployer.CachingAndArtifactsManager;
import org.flowable.engine.impl.bpmn.deployer.ParsedDeployment;
import org.flowable.engine.impl.bpmn.deployer.ParsedDeploymentBuilderFactory;
import org.flowable.engine.impl.bpmn.deployer.ProcessDefinitionDiagramHelper;
import org.flowable.engine.impl.bpmn.deployer.ResourceNameUtil;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.deploy.Deployer;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnDeployer
implements Deployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnDeployer.class);
    protected IdGenerator idGenerator;
    protected ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory;
    protected BpmnDeploymentHelper bpmnDeploymentHelper;
    protected CachingAndArtifactsManager cachingAndArtifactsManager;
    protected ProcessDefinitionDiagramHelper processDefinitionDiagramHelper;

    @Override
    public void deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        LOGGER.debug("Processing deployment {}", (Object)deployment.getName());
        ParsedDeployment parsedDeployment = this.parsedDeploymentBuilderFactory.getBuilderForDeploymentAndSettings(deployment, deploymentSettings).build();
        this.bpmnDeploymentHelper.verifyProcessDefinitionsDoNotShareKeys(parsedDeployment.getAllProcessDefinitions());
        this.bpmnDeploymentHelper.copyDeploymentValuesToProcessDefinitions(parsedDeployment.getDeployment(), parsedDeployment.getAllProcessDefinitions());
        this.bpmnDeploymentHelper.setResourceNamesOnProcessDefinitions(parsedDeployment);
        this.createAndPersistNewDiagramsIfNeeded(parsedDeployment);
        this.setProcessDefinitionDiagramNames(parsedDeployment);
        if (deployment.isNew()) {
            Map<ProcessDefinitionEntity, ProcessDefinitionEntity> mapOfNewProcessDefinitionToPreviousVersion = this.getPreviousVersionsOfProcessDefinitions(parsedDeployment);
            this.setProcessDefinitionVersionsAndIds(parsedDeployment, mapOfNewProcessDefinitionToPreviousVersion);
            this.persistProcessDefinitionsAndAuthorizations(parsedDeployment);
            this.updateTimersAndEvents(parsedDeployment, mapOfNewProcessDefinitionToPreviousVersion);
        } else {
            this.makeProcessDefinitionsConsistentWithPersistedVersions(parsedDeployment);
        }
        this.cachingAndArtifactsManager.updateCachingAndArtifacts(parsedDeployment);
        if (deployment.isNew()) {
            this.dispatchProcessDefinitionEntityInitializedEvent(parsedDeployment);
        }
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            BpmnModel bpmnModel = parsedDeployment.getBpmnModelForProcessDefinition(processDefinition);
            this.createLocalizationValues(processDefinition.getId(), bpmnModel.getProcessById(processDefinition.getKey()));
        }
    }

    protected void createAndPersistNewDiagramsIfNeeded(ParsedDeployment parsedDeployment) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration();
        DeploymentEntity deploymentEntity = parsedDeployment.getDeployment();
        ResourceEntityManager resourceEntityManager = processEngineConfiguration.getResourceEntityManager();
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            ResourceEntity resource;
            if (!this.processDefinitionDiagramHelper.shouldCreateDiagram(processDefinition, deploymentEntity) || (resource = this.processDefinitionDiagramHelper.createDiagramForProcessDefinition(processDefinition, parsedDeployment.getBpmnParseForProcessDefinition(processDefinition))) == null) continue;
            resourceEntityManager.insert(resource, false);
            deploymentEntity.addResource(resource);
        }
    }

    protected void setProcessDefinitionDiagramNames(ParsedDeployment parsedDeployment) {
        Map<String, ResourceEntity> resources = parsedDeployment.getDeployment().getResources();
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            String diagramResourceName = ResourceNameUtil.getProcessDiagramResourceNameFromDeployment(processDefinition, resources);
            processDefinition.setDiagramResourceName(diagramResourceName);
        }
    }

    protected Map<ProcessDefinitionEntity, ProcessDefinitionEntity> getPreviousVersionsOfProcessDefinitions(ParsedDeployment parsedDeployment) {
        LinkedHashMap<ProcessDefinitionEntity, ProcessDefinitionEntity> result = new LinkedHashMap<ProcessDefinitionEntity, ProcessDefinitionEntity>();
        for (ProcessDefinitionEntity newDefinition : parsedDeployment.getAllProcessDefinitions()) {
            ProcessDefinitionEntity existingDefinition = this.bpmnDeploymentHelper.getMostRecentVersionOfProcessDefinition(newDefinition);
            if (existingDefinition == null) continue;
            result.put(newDefinition, existingDefinition);
        }
        return result;
    }

    protected void setProcessDefinitionVersionsAndIds(ParsedDeployment parsedDeployment, Map<ProcessDefinitionEntity, ProcessDefinitionEntity> mapNewToOldProcessDefinitions) {
        CommandContext commandContext = Context.getCommandContext();
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            StartEvent startEvent;
            int version = 1;
            ProcessDefinitionEntity latest = mapNewToOldProcessDefinitions.get(processDefinition);
            if (latest != null) {
                version = latest.getVersion() + 1;
            }
            processDefinition.setVersion(version);
            processDefinition.setId(this.getIdForNewProcessDefinition(processDefinition));
            Process process = parsedDeployment.getProcessModelForProcessDefinition(processDefinition);
            FlowElement initialElement = process.getInitialFlowElement();
            if (initialElement instanceof StartEvent && (startEvent = (StartEvent)initialElement).getFormKey() != null) {
                processDefinition.setHasStartFormKey(true);
            }
            this.cachingAndArtifactsManager.updateProcessDefinitionCache(parsedDeployment);
            if (!CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher().isEnabled()) continue;
            CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_CREATED, processDefinition));
        }
    }

    protected void persistProcessDefinitionsAndAuthorizations(ParsedDeployment parsedDeployment) {
        CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionEntityManager processDefinitionManager = CommandContextUtil.getProcessDefinitionEntityManager(commandContext);
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            processDefinitionManager.insert(processDefinition, false);
            this.bpmnDeploymentHelper.addAuthorizationsForNewProcessDefinition(parsedDeployment.getProcessModelForProcessDefinition(processDefinition), processDefinition);
        }
    }

    protected void updateTimersAndEvents(ParsedDeployment parsedDeployment, Map<ProcessDefinitionEntity, ProcessDefinitionEntity> mapNewToOldProcessDefinitions) {
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            this.bpmnDeploymentHelper.updateTimersAndEvents(processDefinition, mapNewToOldProcessDefinitions.get(processDefinition), parsedDeployment);
        }
    }

    protected void dispatchProcessDefinitionEntityInitializedEvent(ParsedDeployment parsedDeployment) {
        CommandContext commandContext = Context.getCommandContext();
        for (ProcessDefinitionEntity processDefinitionEntity : parsedDeployment.getAllProcessDefinitions()) {
            if (!CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher().isEnabled()) continue;
            CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, processDefinitionEntity));
        }
    }

    protected String getIdForNewProcessDefinition(ProcessDefinitionEntity processDefinition) {
        String nextId = this.idGenerator.getNextId();
        String result = processDefinition.getKey() + ":" + processDefinition.getVersion() + ":" + nextId;
        if (result.length() > 64) {
            result = nextId;
        }
        return result;
    }

    protected void makeProcessDefinitionsConsistentWithPersistedVersions(ParsedDeployment parsedDeployment) {
        for (ProcessDefinitionEntity processDefinition : parsedDeployment.getAllProcessDefinitions()) {
            ProcessDefinitionEntity persistedProcessDefinition = this.bpmnDeploymentHelper.getPersistedInstanceOfProcessDefinition(processDefinition);
            if (persistedProcessDefinition == null) continue;
            processDefinition.setId(persistedProcessDefinition.getId());
            processDefinition.setVersion(persistedProcessDefinition.getVersion());
            processDefinition.setSuspensionState(persistedProcessDefinition.getSuspensionState());
            processDefinition.setHasStartFormKey(persistedProcessDefinition.hasStartFormKey());
            processDefinition.setGraphicalNotationDefined(persistedProcessDefinition.isGraphicalNotationDefined());
        }
    }

    protected void createLocalizationValues(String processDefinitionId, Process process) {
        if (process == null) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        DynamicBpmnService dynamicBpmnService = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDynamicBpmnService();
        ObjectNode infoNode = dynamicBpmnService.getProcessDefinitionInfo(processDefinitionId);
        boolean localizationValuesChanged = false;
        List localizationElements = (List)process.getExtensionElements().get("localization");
        if (localizationElements != null) {
            for (ExtensionElement localizationElement : localizationElements) {
                String processId;
                Iterator iterator;
                if (!"flowable".equals(localizationElement.getNamespacePrefix()) && !"activiti".equals(localizationElement.getNamespacePrefix())) continue;
                String locale = localizationElement.getAttributeValue(null, "locale");
                String name = localizationElement.getAttributeValue(null, "name");
                String documentation = null;
                List documentationElements = (List)localizationElement.getChildElements().get("documentation");
                if (documentationElements != null && (iterator = documentationElements.iterator()).hasNext()) {
                    ExtensionElement documentationElement = (ExtensionElement)iterator.next();
                    documentation = StringUtils.trimToNull((String)documentationElement.getElementText());
                }
                if (!this.isEqualToCurrentLocalizationValue(locale, processId = process.getId(), "name", name, infoNode)) {
                    dynamicBpmnService.changeLocalizationName(locale, processId, name, infoNode);
                    localizationValuesChanged = true;
                }
                if (documentation == null || this.isEqualToCurrentLocalizationValue(locale, processId, "description", documentation, infoNode)) continue;
                dynamicBpmnService.changeLocalizationDescription(locale, processId, documentation, infoNode);
                localizationValuesChanged = true;
            }
        }
        boolean isFlowElementLocalizationChanged = this.localizeFlowElements(process.getFlowElements(), infoNode);
        boolean isDataObjectLocalizationChanged = this.localizeDataObjectElements(process.getDataObjects(), infoNode);
        if (isFlowElementLocalizationChanged || isDataObjectLocalizationChanged) {
            localizationValuesChanged = true;
        }
        if (localizationValuesChanged) {
            dynamicBpmnService.saveProcessDefinitionInfo(processDefinitionId, infoNode);
        }
    }

    protected boolean localizeFlowElements(Collection<FlowElement> flowElements, ObjectNode infoNode) {
        boolean localizationValuesChanged = false;
        if (flowElements == null) {
            return localizationValuesChanged;
        }
        CommandContext commandContext = Context.getCommandContext();
        DynamicBpmnService dynamicBpmnService = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDynamicBpmnService();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof UserTask) && !(flowElement instanceof SubProcess)) continue;
            List localizationElements = (List)flowElement.getExtensionElements().get("localization");
            if (localizationElements != null) {
                for (ExtensionElement localizationElement : localizationElements) {
                    String flowElementId;
                    Iterator iterator;
                    if (!"flowable".equals(localizationElement.getNamespacePrefix()) && !"activiti".equals(localizationElement.getNamespacePrefix())) continue;
                    String locale = localizationElement.getAttributeValue(null, "locale");
                    String name = localizationElement.getAttributeValue(null, "name");
                    String documentation = null;
                    List documentationElements = (List)localizationElement.getChildElements().get("documentation");
                    if (documentationElements != null && (iterator = documentationElements.iterator()).hasNext()) {
                        ExtensionElement documentationElement = (ExtensionElement)iterator.next();
                        documentation = StringUtils.trimToNull((String)documentationElement.getElementText());
                    }
                    if (!this.isEqualToCurrentLocalizationValue(locale, flowElementId = flowElement.getId(), "name", name, infoNode)) {
                        dynamicBpmnService.changeLocalizationName(locale, flowElementId, name, infoNode);
                        localizationValuesChanged = true;
                    }
                    if (documentation == null || this.isEqualToCurrentLocalizationValue(locale, flowElementId, "description", documentation, infoNode)) continue;
                    dynamicBpmnService.changeLocalizationDescription(locale, flowElementId, documentation, infoNode);
                    localizationValuesChanged = true;
                }
            }
            if (!(flowElement instanceof SubProcess)) continue;
            SubProcess subprocess = (SubProcess)flowElement;
            boolean isFlowElementLocalizationChanged = this.localizeFlowElements(subprocess.getFlowElements(), infoNode);
            boolean isDataObjectLocalizationChanged = this.localizeDataObjectElements(subprocess.getDataObjects(), infoNode);
            if (!isFlowElementLocalizationChanged && !isDataObjectLocalizationChanged) continue;
            localizationValuesChanged = true;
        }
        return localizationValuesChanged;
    }

    protected boolean isEqualToCurrentLocalizationValue(String language, String id, String propertyName, String propertyValue, ObjectNode infoNode) {
        boolean isEqual = false;
        JsonNode localizationNode = infoNode.path("localization").path(language).path(id).path(propertyName);
        if (!localizationNode.isMissingNode() && !localizationNode.isNull() && localizationNode.asText().equals(propertyValue)) {
            isEqual = true;
        }
        return isEqual;
    }

    protected boolean localizeDataObjectElements(List<ValuedDataObject> dataObjects, ObjectNode infoNode) {
        boolean localizationValuesChanged = false;
        CommandContext commandContext = Context.getCommandContext();
        DynamicBpmnService dynamicBpmnService = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDynamicBpmnService();
        for (ValuedDataObject dataObject : dataObjects) {
            List localizationElements = (List)dataObject.getExtensionElements().get("localization");
            if (localizationElements == null) continue;
            for (ExtensionElement localizationElement : localizationElements) {
                Iterator iterator;
                if (!"flowable".equals(localizationElement.getNamespacePrefix()) && !"activiti".equals(localizationElement.getNamespacePrefix())) continue;
                String locale = localizationElement.getAttributeValue(null, "locale");
                String name = localizationElement.getAttributeValue(null, "name");
                String documentation = null;
                List documentationElements = (List)localizationElement.getChildElements().get("documentation");
                if (documentationElements != null && (iterator = documentationElements.iterator()).hasNext()) {
                    ExtensionElement documentationElement = (ExtensionElement)iterator.next();
                    documentation = StringUtils.trimToNull((String)documentationElement.getElementText());
                }
                if (name != null && !this.isEqualToCurrentLocalizationValue(locale, dataObject.getId(), "name", name, infoNode)) {
                    dynamicBpmnService.changeLocalizationName(locale, dataObject.getId(), name, infoNode);
                    localizationValuesChanged = true;
                }
                if (documentation == null || this.isEqualToCurrentLocalizationValue(locale, dataObject.getId(), "description", documentation, infoNode)) continue;
                dynamicBpmnService.changeLocalizationDescription(locale, dataObject.getId(), documentation, infoNode);
                localizationValuesChanged = true;
            }
        }
        return localizationValuesChanged;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public ParsedDeploymentBuilderFactory getExParsedDeploymentBuilderFactory() {
        return this.parsedDeploymentBuilderFactory;
    }

    public void setParsedDeploymentBuilderFactory(ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory) {
        this.parsedDeploymentBuilderFactory = parsedDeploymentBuilderFactory;
    }

    public BpmnDeploymentHelper getBpmnDeploymentHelper() {
        return this.bpmnDeploymentHelper;
    }

    public void setBpmnDeploymentHelper(BpmnDeploymentHelper bpmnDeploymentHelper) {
        this.bpmnDeploymentHelper = bpmnDeploymentHelper;
    }

    public CachingAndArtifactsManager getCachingAndArtifcatsManager() {
        return this.cachingAndArtifactsManager;
    }

    public void setCachingAndArtifactsManager(CachingAndArtifactsManager manager) {
        this.cachingAndArtifactsManager = manager;
    }

    public ProcessDefinitionDiagramHelper getProcessDefinitionDiagramHelper() {
        return this.processDefinitionDiagramHelper;
    }

    public void setProcessDefinitionDiagramHelper(ProcessDefinitionDiagramHelper processDefinitionDiagramHelper) {
        this.processDefinitionDiagramHelper = processDefinitionDiagramHelper;
    }
}

