/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.tenant;

import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.tenant.ChangeTenantIdResult;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.tenant.ChangeTenantIdBuilderImpl;
import org.flowable.common.engine.impl.tenant.DefaultChangeTenantIdResult;

public abstract class BaseChangeTenantIdCmd
implements Command<ChangeTenantIdResult> {
    protected final ChangeTenantIdBuilderImpl builder;
    protected String engineScopeType;

    protected BaseChangeTenantIdCmd(ChangeTenantIdBuilderImpl builder, String engineScopeType) {
        this.builder = builder;
        this.engineScopeType = engineScopeType;
    }

    @Override
    public ChangeTenantIdResult execute(CommandContext commandContext) {
        String sourceTenantId = this.builder.getSourceTenantId();
        String targetTenantId = this.builder.getTargetTenantId();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("sourceTenantId", sourceTenantId);
        parameters.put("targetTenantId", targetTenantId);
        parameters.put("definitionTenantId", this.builder.getDefinitionTenantId());
        DbSqlSession dbSqlSession = commandContext.getSession(DbSqlSession.class);
        Map<String, Long> results = this.executeOperation(dbSqlSession, parameters);
        DefaultChangeTenantIdResult result = new DefaultChangeTenantIdResult(results);
        this.beforeReturn(commandContext, result);
        return result;
    }

    protected void beforeReturn(CommandContext commandContext, ChangeTenantIdResult result) {
    }

    protected abstract Map<String, Long> executeOperation(DbSqlSession var1, Map<String, Object> var2);

    protected AbstractEngineConfiguration getEngineConfiguration(CommandContext commandContext) {
        AbstractEngineConfiguration configuration = commandContext.getEngineConfigurations().get(this.engineScopeType);
        if (configuration != null) {
            return configuration;
        }
        throw new FlowableException("There is no engine registered for the scope type " + this.engineScopeType);
    }
}

