/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.engine.impl.deployer;

import java.util.LinkedHashMap;
import java.util.Map;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.dmn.engine.DmnEngineConfiguration;
import org.flowable.dmn.engine.impl.deployer.CachingAndArtifactsManager;
import org.flowable.dmn.engine.impl.deployer.DecisionRequirementsDiagramHelper;
import org.flowable.dmn.engine.impl.deployer.DmnDeploymentHelper;
import org.flowable.dmn.engine.impl.deployer.ParsedDeployment;
import org.flowable.dmn.engine.impl.deployer.ParsedDeploymentBuilderFactory;
import org.flowable.dmn.engine.impl.persistence.deploy.Deployer;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntity;
import org.flowable.dmn.engine.impl.persistence.entity.DecisionEntityManager;
import org.flowable.dmn.engine.impl.persistence.entity.DmnDeploymentEntity;
import org.flowable.dmn.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmnDeployer
implements Deployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnDeployer.class);
    protected IdGenerator idGenerator;
    protected ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory;
    protected DmnDeploymentHelper dmnDeploymentHelper;
    protected CachingAndArtifactsManager cachingAndArtifactsManager;
    protected DecisionRequirementsDiagramHelper decisionRequirementsDiagramHelper;
    protected boolean usePrefixId;

    @Override
    public void deploy(DmnDeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        LOGGER.debug("Processing deployment {}", (Object)deployment.getName());
        ParsedDeployment parsedDeployment = this.parsedDeploymentBuilderFactory.getBuilderForDeploymentAndSettings(deployment, deploymentSettings).build();
        this.dmnDeploymentHelper.copyDeploymentValuesToDecisions(parsedDeployment.getDeployment(), parsedDeployment.getAllDecisions());
        this.dmnDeploymentHelper.setResourceNamesOnDecisions(parsedDeployment);
        this.dmnDeploymentHelper.createAndPersistNewDiagramsIfNeeded(parsedDeployment, this.decisionRequirementsDiagramHelper);
        this.dmnDeploymentHelper.setDecisionDefinitionDiagramNames(parsedDeployment);
        if (deployment.isNew()) {
            Map<DecisionEntity, DecisionEntity> mapOfNewDefinitionToPreviousVersion = this.getPreviousVersionsOfDecisions(parsedDeployment);
            this.setDecisionVersionsAndIds(parsedDeployment, mapOfNewDefinitionToPreviousVersion);
            this.persistDecisions(parsedDeployment);
        } else {
            this.makeDecisionsConsistentWithPersistedVersions(parsedDeployment);
        }
        this.cachingAndArtifactsManager.updateCachingAndArtifacts(parsedDeployment);
    }

    protected Map<DecisionEntity, DecisionEntity> getPreviousVersionsOfDecisions(ParsedDeployment parsedDeployment) {
        LinkedHashMap<DecisionEntity, DecisionEntity> result = new LinkedHashMap<DecisionEntity, DecisionEntity>();
        for (DecisionEntity newDecision : parsedDeployment.getAllDecisions()) {
            DecisionEntity existingDecision = this.dmnDeploymentHelper.getMostRecentVersionOfDecision(newDecision);
            if (existingDecision == null) continue;
            result.put(newDecision, existingDecision);
        }
        return result;
    }

    protected void setDecisionVersionsAndIds(ParsedDeployment parsedDeployment, Map<DecisionEntity, DecisionEntity> mapNewToOldDecisions) {
        for (DecisionEntity decision : parsedDeployment.getAllDecisions()) {
            int version = 1;
            DecisionEntity latest = mapNewToOldDecisions.get(decision);
            if (latest != null) {
                version = latest.getVersion() + 1;
            }
            decision.setVersion(version);
            if (this.usePrefixId) {
                decision.setId(decision.getIdPrefix() + this.idGenerator.getNextId());
                continue;
            }
            String id = this.idGenerator.getNextId();
            decision.setId(id);
        }
    }

    protected void persistDecisions(ParsedDeployment parsedDeployment) {
        DmnEngineConfiguration dmnEngineConfiguration = CommandContextUtil.getDmnEngineConfiguration();
        DecisionEntityManager decisionEntityManager = dmnEngineConfiguration.getDecisionEntityManager();
        for (DecisionEntity decision : parsedDeployment.getAllDecisions()) {
            decisionEntityManager.insert(decision);
        }
    }

    protected void makeDecisionsConsistentWithPersistedVersions(ParsedDeployment parsedDeployment) {
        for (DecisionEntity decision : parsedDeployment.getAllDecisions()) {
            DecisionEntity persistedDecision = this.dmnDeploymentHelper.getPersistedInstanceOfDecision(decision);
            if (persistedDecision == null) continue;
            decision.setId(persistedDecision.getId());
            decision.setVersion(persistedDecision.getVersion());
        }
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public ParsedDeploymentBuilderFactory getExParsedDeploymentBuilderFactory() {
        return this.parsedDeploymentBuilderFactory;
    }

    public void setParsedDeploymentBuilderFactory(ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory) {
        this.parsedDeploymentBuilderFactory = parsedDeploymentBuilderFactory;
    }

    public DmnDeploymentHelper getDmnDeploymentHelper() {
        return this.dmnDeploymentHelper;
    }

    public void setDmnDeploymentHelper(DmnDeploymentHelper dmnDeploymentHelper) {
        this.dmnDeploymentHelper = dmnDeploymentHelper;
    }

    public CachingAndArtifactsManager getCachingAndArtifcatsManager() {
        return this.cachingAndArtifactsManager;
    }

    public void setCachingAndArtifactsManager(CachingAndArtifactsManager manager) {
        this.cachingAndArtifactsManager = manager;
    }

    public boolean isUsePrefixId() {
        return this.usePrefixId;
    }

    public void setUsePrefixId(boolean usePrefixId) {
        this.usePrefixId = usePrefixId;
    }

    public DecisionRequirementsDiagramHelper getDecisionRequirementsDiagramHelper() {
        return this.decisionRequirementsDiagramHelper;
    }

    public void setDecisionRequirementsDiagramHelper(DecisionRequirementsDiagramHelper decisionRequirementsDiagramHelper) {
        this.decisionRequirementsDiagramHelper = decisionRequirementsDiagramHelper;
    }
}

