/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.api;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.flowable.dmn.api.ExpressionExecution;
import org.flowable.dmn.api.RuleExecutionAuditContainer;
import org.flowable.dmn.model.DecisionRule;
import org.flowable.dmn.model.HitPolicy;
import org.joda.time.DateTime;

public class DecisionExecutionAuditContainer {
    protected String decisionKey;
    protected String decisionName;
    protected String hitPolicy;
    protected String dmnDeploymentId;
    protected Date startTime;
    protected Date endTime;
    protected Map<String, Object> inputVariables;
    protected Map<String, String> inputVariableTypes;
    protected Map<Integer, RuleExecutionAuditContainer> ruleExecutions = new HashMap<Integer, RuleExecutionAuditContainer>();
    protected Boolean failed = Boolean.FALSE;
    protected String exceptionMessage;
    protected Boolean strictMode;

    public DecisionExecutionAuditContainer() {
    }

    public DecisionExecutionAuditContainer(String decisionKey, String decisionName, HitPolicy hitPolicy, Boolean strictMode, Map<String, Object> inputVariables) {
        this.startTime = new Date();
        this.decisionKey = decisionKey;
        this.decisionName = decisionName;
        this.hitPolicy = hitPolicy.getValue();
        this.strictMode = strictMode;
        this.inputVariableTypes = this.getVariablesTypeMap(inputVariables);
        this.inputVariables = this.createDefensiveCopyInputVariables(inputVariables);
    }

    protected Map<String, String> getVariablesTypeMap(Map<String, Object> variableValuesMap) {
        HashMap<String, String> variablesTypesMap = new HashMap<String, String>();
        if (variableValuesMap == null || variableValuesMap.isEmpty()) {
            return variablesTypesMap;
        }
        for (String name : variableValuesMap.keySet()) {
            Object value = variableValuesMap.get(name);
            String type = null;
            if (value != null) {
                if (DecisionExecutionAuditContainer.isString(value)) {
                    type = "string";
                } else if (DecisionExecutionAuditContainer.isDate(value)) {
                    type = "date";
                } else if (DecisionExecutionAuditContainer.isNumber(value)) {
                    type = "number";
                } else if (DecisionExecutionAuditContainer.isBoolean(value)) {
                    type = "boolean";
                }
            }
            variablesTypesMap.put(name, type);
        }
        return variablesTypesMap;
    }

    public void stopAudit() {
        this.endTime = new Date();
    }

    public void addRuleEntry(DecisionRule rule) {
        this.ruleExecutions.put(rule.getRuleNumber(), new RuleExecutionAuditContainer(rule.getRuleNumber()));
    }

    public void markRuleEnd(int ruleNumber) {
        this.ruleExecutions.get(ruleNumber).markRuleEnd();
    }

    public void markRuleValid(int ruleNumber) {
        this.ruleExecutions.get(ruleNumber).setValid();
    }

    public void addInputEntry(int ruleNumber, int inputNumber, String inputEntryId, Boolean executionResult) {
        this.ruleExecutions.get(ruleNumber).addConditionResult(inputNumber, new ExpressionExecution(inputEntryId, executionResult));
    }

    public void addInputEntry(int ruleNumber, int inputNumber, String inputEntryId, String exceptionMessage, Boolean executionResult) {
        this.ruleExecutions.get(ruleNumber).addConditionResult(inputNumber, new ExpressionExecution(inputEntryId, exceptionMessage, executionResult));
    }

    public void addOutputEntry(int ruleNumber, int outputNumber, String outputEntryId, Object executionResult) {
        this.ruleExecutions.get(ruleNumber).addConclusionResult(outputNumber, new ExpressionExecution(outputEntryId, executionResult));
    }

    public void addOutputEntry(int ruleNumber, int outputNumber, String outputEntryId, String exceptionMessage, Object executionResult) {
        this.ruleExecutions.get(ruleNumber).addConclusionResult(outputNumber, new ExpressionExecution(outputEntryId, exceptionMessage, executionResult));
    }

    public String getDecisionKey() {
        return this.decisionKey;
    }

    public String getDecisionName() {
        return this.decisionName;
    }

    public String getHitPolicy() {
        return this.hitPolicy;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Map<String, Object> getInputVariables() {
        return this.inputVariables;
    }

    public Map<Integer, RuleExecutionAuditContainer> getRuleExecutions() {
        return this.ruleExecutions;
    }

    public String getDmnDeploymentId() {
        return this.dmnDeploymentId;
    }

    public void setDmnDeploymentId(String dmnDeploymentId) {
        this.dmnDeploymentId = dmnDeploymentId;
    }

    public Boolean isFailed() {
        return this.failed;
    }

    public void setFailed() {
        this.failed = Boolean.TRUE;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public Map<String, String> getInputVariableTypes() {
        return this.inputVariableTypes;
    }

    public void setInputVariableTypes(Map<String, String> inputVariableTypes) {
        this.inputVariableTypes = inputVariableTypes;
    }

    public static boolean isBoolean(Object obj) {
        return obj instanceof Boolean;
    }

    public static boolean isDate(Object obj) {
        return obj instanceof Date || obj instanceof DateTime;
    }

    public static boolean isString(Object obj) {
        return obj instanceof String;
    }

    public static boolean isNumber(Object obj) {
        return obj instanceof Number;
    }

    protected Map<String, Object> createDefensiveCopyInputVariables(Map<String, Object> inputVariables) {
        HashMap<String, Object> defensiveCopyMap = new HashMap<String, Object>();
        if (inputVariables != null) {
            for (Map.Entry<String, Object> entry : inputVariables.entrySet()) {
                Object newValue = null;
                if (entry.getValue() != null) {
                    newValue = entry.getValue() instanceof Long ? new Long((Long)entry.getValue()) : (entry.getValue() instanceof Double ? new Double((Double)entry.getValue()) : (entry.getValue() instanceof Integer ? new Integer((Integer)entry.getValue()) : (entry.getValue() instanceof Date ? new Date(((Date)entry.getValue()).getTime()) : (entry.getValue() instanceof Boolean ? new Boolean((Boolean)entry.getValue()) : new String(entry.getValue().toString())))));
                }
                defensiveCopyMap.put(entry.getKey(), newValue);
            }
        }
        return defensiveCopyMap;
    }
}

