/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.rest.variable;

import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.variable.EngineRestVariable;
import org.flowable.common.rest.variable.RestVariableConverter;

public class BooleanRestVariableConverter
implements RestVariableConverter {
    @Override
    public String getRestTypeName() {
        return "boolean";
    }

    @Override
    public Class<?> getVariableType() {
        return Boolean.class;
    }

    @Override
    public Object getVariableValue(EngineRestVariable result) {
        if (result.getValue() != null) {
            if (!(result.getValue() instanceof Boolean)) {
                throw new FlowableIllegalArgumentException("Converter can only convert booleans");
            }
            return result.getValue();
        }
        return null;
    }

    @Override
    public void convertVariableValue(Object variableValue, EngineRestVariable result) {
        if (variableValue != null) {
            if (!(variableValue instanceof Boolean)) {
                throw new FlowableIllegalArgumentException("Converter can only convert booleans");
            }
            result.setValue(variableValue);
        } else {
            result.setValue(null);
        }
    }
}

