/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.flowable.cmmn.model.CmmnElement;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.ScriptInfo;

public class FlowableListener
extends CmmnElement {
    protected String event;
    protected String sourceState;
    protected String targetState;
    protected String implementationType;
    protected String implementation;
    protected List<FieldExtension> fieldExtensions = new ArrayList<FieldExtension>();
    protected String onTransaction;
    protected ScriptInfo scriptInfo;
    @JsonIgnore
    protected Object instance;

    public FlowableListener() {
        this.setId(UUID.randomUUID().toString());
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getSourceState() {
        return this.sourceState;
    }

    public void setSourceState(String sourceState) {
        this.sourceState = sourceState;
    }

    public String getTargetState() {
        return this.targetState;
    }

    public void setTargetState(String targetState) {
        this.targetState = targetState;
    }

    public String getImplementationType() {
        return this.implementationType;
    }

    public void setImplementationType(String implementationType) {
        this.implementationType = implementationType;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public List<FieldExtension> getFieldExtensions() {
        return this.fieldExtensions;
    }

    public void setFieldExtensions(List<FieldExtension> fieldExtensions) {
        this.fieldExtensions = fieldExtensions;
    }

    public String getOnTransaction() {
        return this.onTransaction;
    }

    public void setOnTransaction(String onTransaction) {
        this.onTransaction = onTransaction;
    }

    public ScriptInfo getScriptInfo() {
        return this.scriptInfo;
    }

    public void setScriptInfo(ScriptInfo scriptInfo) {
        this.scriptInfo = scriptInfo;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    public FlowableListener clone() {
        FlowableListener clone = new FlowableListener();
        clone.setValues(this);
        return clone;
    }

    public void setValues(FlowableListener otherListener) {
        super.setValues(otherListener);
        this.setEvent(otherListener.getEvent());
        this.setSourceState(otherListener.getSourceState());
        this.setTargetState(otherListener.getTargetState());
        this.setImplementation(otherListener.getImplementation());
        this.setImplementationType(otherListener.getImplementationType());
        this.setOnTransaction(otherListener.getOnTransaction());
        Optional.ofNullable(otherListener.getScriptInfo()).map(ScriptInfo::clone).ifPresent(this::setScriptInfo);
        this.fieldExtensions = new ArrayList<FieldExtension>();
        if (otherListener.getFieldExtensions() != null && !otherListener.getFieldExtensions().isEmpty()) {
            for (FieldExtension extension : otherListener.getFieldExtensions()) {
                this.fieldExtensions.add(extension.clone());
            }
        }
    }
}

