/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.runtime.CaseInstanceStartEventSubscriptionModificationBuilder;
import org.flowable.cmmn.engine.impl.runtime.CmmnRuntimeServiceImpl;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;

public class CaseInstanceStartEventSubscriptionModificationBuilderImpl
implements CaseInstanceStartEventSubscriptionModificationBuilder {
    protected final CmmnRuntimeServiceImpl cmmnRuntimeService;
    protected String caseDefinitionId;
    protected String newCaseDefinitionId;
    protected String tenantId;
    protected final Map<String, Object> correlationParameterValues = new HashMap<String, Object>();

    public CaseInstanceStartEventSubscriptionModificationBuilderImpl(CmmnRuntimeServiceImpl cmmnRuntimeService) {
        this.cmmnRuntimeService = cmmnRuntimeService;
    }

    public CaseInstanceStartEventSubscriptionModificationBuilder caseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    public CaseInstanceStartEventSubscriptionModificationBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public CaseInstanceStartEventSubscriptionModificationBuilder addCorrelationParameterValue(String parameterName, Object parameterValue) {
        this.correlationParameterValues.put(parameterName, parameterValue);
        return this;
    }

    public CaseInstanceStartEventSubscriptionModificationBuilder addCorrelationParameterValues(Map<String, Object> parameters) {
        this.correlationParameterValues.putAll(parameters);
        return this;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public boolean hasNewCaseDefinitionId() {
        return StringUtils.isNotBlank((CharSequence)this.newCaseDefinitionId);
    }

    public String getNewCaseDefinitionId() {
        return this.newCaseDefinitionId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean hasCorrelationParameterValues() {
        return this.correlationParameterValues.size() > 0;
    }

    public Map<String, Object> getCorrelationParameterValues() {
        return this.correlationParameterValues;
    }

    public void migrateToLatestCaseDefinition() {
        this.checkValidInformation();
        this.cmmnRuntimeService.migrateCaseInstanceStartEventSubscriptionsToCaseDefinitionVersion(this);
    }

    public void migrateToCaseDefinition(String caseDefinitionId) {
        this.newCaseDefinitionId = caseDefinitionId;
        this.checkValidInformation();
        this.cmmnRuntimeService.migrateCaseInstanceStartEventSubscriptionsToCaseDefinitionVersion(this);
    }

    protected void checkValidInformation() {
        if (StringUtils.isEmpty((CharSequence)this.caseDefinitionId)) {
            throw new FlowableIllegalArgumentException("The case definition must be provided using the exact id of the version the subscription was registered for.");
        }
    }
}

