/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.List;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.engine.impl.agenda.CmmnEngineAgenda;
import org.flowable.cmmn.engine.impl.deployer.CmmnDeploymentManager;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.VariableEventListener;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class SetVariableCmd
implements Command<Void> {
    protected String caseInstanceId;
    protected String variableName;
    protected Object variableValue;

    public SetVariableCmd(String caseInstanceId, String variableName, Object variableValue) {
        this.caseInstanceId = caseInstanceId;
        this.variableName = variableName;
        this.variableValue = variableValue;
    }

    public Void execute(CommandContext commandContext) {
        if (this.caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("caseInstanceId is null");
        }
        if (this.variableName == null) {
            throw new FlowableIllegalArgumentException("variable name is null");
        }
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(commandContext).findById(this.caseInstanceId);
        if (caseInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No case instance found for id " + this.caseInstanceId, CaseInstanceEntity.class);
        }
        caseInstanceEntity.setVariable(this.variableName, this.variableValue);
        CmmnEngineAgenda agenda = CommandContextUtil.getAgenda(commandContext);
        CmmnDeploymentManager deploymentManager = CommandContextUtil.getCmmnEngineConfiguration(commandContext).getDeploymentManager();
        CaseDefinition caseDefinition = deploymentManager.findDeployedCaseDefinitionById(caseInstanceEntity.getCaseDefinitionId());
        boolean evaluateVariableEventListener = false;
        if (caseDefinition != null) {
            CmmnModel cmmnModel = deploymentManager.resolveCaseDefinition(caseDefinition).getCmmnModel();
            for (Case caze : cmmnModel.getCases()) {
                List variableEventListeners = caze.findPlanItemDefinitionsOfType(VariableEventListener.class);
                for (VariableEventListener variableEventListener : variableEventListeners) {
                    if (!this.variableName.equals(variableEventListener.getVariableName())) continue;
                    evaluateVariableEventListener = true;
                    break;
                }
                if (!evaluateVariableEventListener) continue;
                break;
            }
        }
        if (evaluateVariableEventListener) {
            agenda.planEvaluateVariableEventListenersOperation(this.caseInstanceId);
        }
        agenda.planEvaluateCriteriaOperation(this.caseInstanceId);
        return null;
    }
}

