/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.flowable.cmmn.api.runtime.PlanItemInstanceTransitionBuilder;
import org.flowable.cmmn.engine.impl.cmd.CompleteStagePlanItemInstanceCmd;
import org.flowable.cmmn.engine.impl.cmd.DisablePlanItemInstanceCmd;
import org.flowable.cmmn.engine.impl.cmd.EnablePlanItemInstanceCmd;
import org.flowable.cmmn.engine.impl.cmd.StartPlanItemInstanceCmd;
import org.flowable.cmmn.engine.impl.cmd.TerminatePlanItemInstanceCmd;
import org.flowable.cmmn.engine.impl.cmd.TriggerPlanItemInstanceCmd;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.form.api.FormInfo;

public class PlanItemInstanceTransitionBuilderImpl
implements PlanItemInstanceTransitionBuilder {
    protected CommandExecutor commandExecutor;
    protected String planItemInstanceId;
    protected Map<String, Object> variables;
    protected Map<String, Object> formVariables;
    protected String formOutcome;
    protected FormInfo formInfo;
    protected Map<String, Object> localVariables;
    protected Map<String, Object> transientVariables;
    protected Map<String, Object> childTaskVariables;
    protected Map<String, Object> childTaskFormVariables;
    protected String childTaskFormOutcome;
    protected FormInfo childTaskFormInfo;

    public PlanItemInstanceTransitionBuilderImpl(CommandExecutor commandExecutor, String planItemInstanceId) {
        this.commandExecutor = commandExecutor;
        this.planItemInstanceId = planItemInstanceId;
    }

    public PlanItemInstanceTransitionBuilder variable(String variableName, Object variableValue) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        this.variables.put(variableName, variableValue);
        return this;
    }

    public PlanItemInstanceTransitionBuilder variables(Map<String, Object> variables) {
        if (this.variables == null) {
            this.variables = new HashMap<String, Object>();
        }
        if (variables != null) {
            this.variables.putAll(variables);
        }
        return this;
    }

    public PlanItemInstanceTransitionBuilder formVariables(Map<String, Object> variables, FormInfo formInfo, String outcome) {
        if (formInfo == null) {
            throw new FlowableIllegalArgumentException("formInfo is null");
        }
        if (this.formVariables == null) {
            this.formVariables = new HashMap<String, Object>();
        }
        if (variables != null) {
            this.formVariables.putAll(variables);
        }
        this.formOutcome = outcome;
        this.formInfo = formInfo;
        return this;
    }

    public PlanItemInstanceTransitionBuilder localVariable(String variableName, Object variableValue) {
        if (this.localVariables == null) {
            this.localVariables = new HashMap<String, Object>();
        }
        this.localVariables.put(variableName, variableValue);
        return this;
    }

    public PlanItemInstanceTransitionBuilder localVariables(Map<String, Object> localVariables) {
        if (this.localVariables == null) {
            this.localVariables = new HashMap<String, Object>();
        }
        if (localVariables != null) {
            this.localVariables.putAll(localVariables);
        }
        return this;
    }

    public PlanItemInstanceTransitionBuilder transientVariable(String variableName, Object variableValue) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap<String, Object>();
        }
        this.transientVariables.put(variableName, variableValue);
        return this;
    }

    public PlanItemInstanceTransitionBuilder transientVariables(Map<String, Object> transientVariables) {
        if (this.transientVariables == null) {
            this.transientVariables = new HashMap<String, Object>();
        }
        if (transientVariables != null) {
            this.transientVariables.putAll(transientVariables);
        }
        return this;
    }

    public PlanItemInstanceTransitionBuilder childTaskVariable(String variableName, Object variableValue) {
        if (this.childTaskVariables == null) {
            this.childTaskVariables = new HashMap<String, Object>();
        }
        this.childTaskVariables.put(variableName, variableValue);
        return this;
    }

    public PlanItemInstanceTransitionBuilder childTaskVariables(Map<String, Object> childTaskVariables) {
        if (this.childTaskVariables == null) {
            this.childTaskVariables = new HashMap<String, Object>();
        }
        if (childTaskVariables != null) {
            this.childTaskVariables.putAll(childTaskVariables);
        }
        return this;
    }

    public PlanItemInstanceTransitionBuilder childTaskFormVariables(Map<String, Object> variables, FormInfo formInfo, String outcome) {
        if (formInfo == null) {
            throw new FlowableIllegalArgumentException("formInfo is null");
        }
        if (this.childTaskFormVariables == null) {
            this.childTaskFormVariables = new HashMap<String, Object>();
        }
        if (variables != null) {
            this.childTaskFormVariables.putAll(variables);
        }
        this.childTaskFormOutcome = outcome;
        this.childTaskFormInfo = formInfo;
        return this;
    }

    public void trigger() {
        this.validateChildTaskVariablesNotSet();
        this.commandExecutor.execute((Command)new TriggerPlanItemInstanceCmd(this.planItemInstanceId, this.variables, this.formVariables, this.formOutcome, this.formInfo, this.localVariables, this.transientVariables));
    }

    public void enable() {
        this.validateChildTaskVariablesNotSet();
        this.commandExecutor.execute((Command)new EnablePlanItemInstanceCmd(this.planItemInstanceId, this.variables, this.formVariables, this.formOutcome, this.formInfo, this.localVariables, this.transientVariables));
    }

    public void disable() {
        this.validateChildTaskVariablesNotSet();
        this.commandExecutor.execute((Command)new DisablePlanItemInstanceCmd(this.planItemInstanceId, this.variables, this.formVariables, this.formOutcome, this.formInfo, this.localVariables, this.transientVariables));
    }

    public void start() {
        this.commandExecutor.execute((Command)new StartPlanItemInstanceCmd(this.planItemInstanceId, this.variables, this.formVariables, this.formOutcome, this.formInfo, this.localVariables, this.transientVariables, this.childTaskVariables, this.childTaskFormVariables, this.childTaskFormOutcome, this.childTaskFormInfo));
    }

    public void terminate() {
        this.validateChildTaskVariablesNotSet();
        this.commandExecutor.execute((Command)new TerminatePlanItemInstanceCmd(this.planItemInstanceId, this.variables, this.formVariables, this.formOutcome, this.formInfo, this.localVariables, this.transientVariables));
    }

    public void completeStage() {
        this.validateChildTaskVariablesNotSet();
        this.commandExecutor.execute((Command)new CompleteStagePlanItemInstanceCmd(this.planItemInstanceId, this.variables, this.formVariables, this.formOutcome, this.formInfo, this.localVariables, this.transientVariables, false));
    }

    public void forceCompleteStage() {
        this.validateChildTaskVariablesNotSet();
        this.commandExecutor.execute((Command)new CompleteStagePlanItemInstanceCmd(this.planItemInstanceId, this.variables, this.formVariables, this.formOutcome, this.formInfo, this.localVariables, this.transientVariables, true));
    }

    protected void validateChildTaskVariablesNotSet() {
        if (this.childTaskVariables != null) {
            throw new FlowableIllegalArgumentException("Child task variables can only be set when starting a plan item instance");
        }
        if (this.childTaskFormInfo != null) {
            throw new FlowableIllegalArgumentException("Child form variables can only be set when starting a plan item instance");
        }
    }
}

