/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.job;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.batch.api.Batch;
import org.flowable.batch.api.BatchPart;
import org.flowable.batch.api.BatchService;
import org.flowable.cmmn.api.migration.CaseInstanceMigrationDocument;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.job.AbstractCaseInstanceMigrationJobHandler;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationDocumentImpl;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationManager;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class CaseInstanceMigrationJobHandler
extends AbstractCaseInstanceMigrationJobHandler {
    public static final String TYPE = "case-migration";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        CmmnEngineConfiguration engineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        BatchService batchService = engineConfiguration.getBatchServiceConfiguration().getBatchService();
        CaseInstanceMigrationManager migrationManager = engineConfiguration.getCaseInstanceMigrationManager();
        String batchPartId = CaseInstanceMigrationJobHandler.getBatchPartIdFromHandlerCfg(configuration);
        BatchPart batchPart = batchService.getBatchPart(batchPartId);
        Batch batch = batchService.getBatch(batchPart.getBatchId());
        CaseInstanceMigrationDocument migrationDocument = CaseInstanceMigrationDocumentImpl.fromJson(batch.getBatchDocumentJson(engineConfiguration.getEngineCfgKey()));
        String exceptionMessage = null;
        try {
            migrationManager.migrateCaseInstance(batchPart.getScopeId(), migrationDocument, commandContext);
        }
        catch (FlowableException e) {
            exceptionMessage = e.getMessage();
        }
        String resultAsJsonString = CaseInstanceMigrationJobHandler.prepareResultAsJsonString(exceptionMessage);
        if (exceptionMessage != null) {
            batchService.completeBatchPart(batchPartId, "fail", resultAsJsonString);
        } else {
            batchService.completeBatchPart(batchPartId, "success", resultAsJsonString);
        }
    }

    protected static String prepareResultAsJsonString(String exceptionMessage) {
        ObjectNode objectNode = CaseInstanceMigrationJobHandler.getObjectMapper().createObjectNode();
        if (exceptionMessage == null) {
            objectNode.put("resultStatus", "success");
        } else {
            objectNode.put("resultStatus", "fail");
            objectNode.put("resultMessage", exceptionMessage);
        }
        return objectNode.toString();
    }
}

